
// 用于扫描条形码或二维码
function scanCode(obj) {
}

// 用于加载物料选择菜单
function selectMaterial() {

}

// 用于通过物料名称获取物料
function selectMaterialByName() {

}

// 用于编码查询
function selectCode(obj) {
}


// 用于扫描物料码
function scanCodeForMaterial() {

}

// 用于计算盘点结果
function calculateForMaterial(obj) {

}


function updateTableShowForMaterial() {

}






layui.use(['form', 'step', 'flow', 'table', 'inputTag'], function () {
    var $ = layui.$,
        form = layui.form,
        table = layui.table,
        inputTag = layui.inputTag,
        dropdown = layui.dropdown, //下拉菜单
        step = layui.step;
    departmentManagerIdForMaterial = $("#departmentManagerIdForMaterial").val();



    let tagData = [];
    let tempData = $("#departmentManagerForMaterial").val().split(",");
    $.each(tempData, function (index, item) {
        if (item !== "") {
            tagData.push(item)
        }
    });
    $("#departmentManagerForMaterial").val("");


    let tagLabel = inputTag.render({
        elem: '#departmentManagerForMaterial',
        data: tagData,//初始值
        removeKeyNum: 8,//删除按键编号 默认，BackSpace 键
        createKeyNum: 13,//创建按键编号 默认，Enter 键
        onChange: function (data, value, type, index) {
            if (type === "remove") {
                let split = departmentManagerIdForMaterial.split(",");
                split.splice(index, 1);
                departmentManagerIdForMaterial = split.toString();
                $("#departmentManagerIdForMaterial").val(departmentManagerIdForMaterial);
            }
        }
    });

    // 用于实现点击搜索按钮
    selectMaterial = function (obj) {
        var mname = $("#mname").val();
        mname = mname.split(",")[0];
        layer.open({
            type: 2,
            title: '弹窗内容',
            skin: 'layui-layer-rim',
            maxmin: true,
            shadeClose: true, //点击遮罩关闭层
            area: ['70%', '70%'],
            content: '/selectMaterial?mname=' + mname + '&type=2',
            move: '.layui-layer-title',
            fixed: false,
            success: function (layero, index) {
                var children = layero.children();
                var content = $(children[1]);
                var iframeChildren = $(content.children());
                content.css('height', '100%');
                iframeChildren.css('height', '100%');
            },
            end: function () {
                var mid =  $("#mid").val();
                if (mid !== '') {
                let loading2 = layer.open({ type: 3, shade: [0.25, '#000'], icon: 2, speed: 0});
                    $.ajax({
                        url: "/material/findMatrialById?mid=" + mid + "&type=out",
                        type: "get",
                        dataType: 'json',
                        contentType: "application/json;charset=utf-8",
                        success: function (d) {
                            var material = d.data.materialById;
                            $("#mname").val(material.mname);
                            $("#code").val(material.code);
                            $("#version").val(material.version);
                            $("#mtype").val(material.typeName);
                            $("#texture").val(material.texture);
                            $("#brand").val(material.brand);
                            layer.close(loading2);
                            form.render();
                        }
                    });
                }
            }
        });
    };



    updateTableShowForMaterial = function () {
        let req = {};
        req.mid = $("#mid").val();
        table.reloadData('currentTableForMaterial', {
            url: '/material/findMaterialByConditionForStockTaking',
            page: {
                curr: 1
            },
            where: req
        }, 'data');
    };

    table.render({
        elem: "#currentTableForMaterial",
        url: '/material/findMaterialByConditionForStockTaking',
        parseData: function (res) { //res 即为原始返回的数据
            return {
                "status": res.status, //解析接口状态
                "message": res.statusInfo.message, //解析提示文本
                "count": res.count, //解析数据长度
                "data": res.data //解析数据列表
            };
        },
        request: {
            pageName: 'page', //页码的参数名称，默认：page
            limitName: 'size' //每页数据量的参数名，默认：limit
        },
        response: {
            statusName: 'status' //规定数据状态的字段名称，默认：code
            , statusCode: 200 //规定成功的状态码，默认：0
            , msgName: 'message' //规定状态信息的字段名称，默认：msg
            , countName: 'count' //规定数据总数的字段名称，默认：count
            , dataName: 'data' //规定数据列表的字段名称，默认：data
        },
        where: {
            depositoryId: "-1"
        },
        height: 'full-255',//固定高度-即固定表头固定第一行首行
        cols: [
            [
                {field: 'mcode', width: 100, title: '存货编码', fixed: 'left'},
                {field: 'mname', width: 150, title: '物料名称'},
                {field: 'version', width: 150, title: '规格型号',},
                {field: 'tname', width: 120, title: '物料种类'},
                {field: 'dname', width: 150, title: '所处仓库'},
                {field: 'pcode', width: 150, title: '所处库位',},
                {title: '计量单位', width: 200, templet: '#changeUnit', align: "center"},
                {field: 'inventory', width: 100, title: '库存数'},
                {field: 'stockTakingQuantity', width: 100, title: '盘点数', edit: 'quantity'},
                {field: 'takingResultString', width: 100, title: '盘点结果'},
                {field: 'takingInventory', width: 100, title: '盈亏数量'},
                {title: '操作', width: 100, toolbar: '#currentTableBarForLocation', align: "center"}
            ]
        ],
        limits: [10, 15, 20, 25, 50, 100],
        limit: 10,
        page: true,
        skin: 'line',
        done: function (res, curr, count) {
            $.each(res['data'], function (i, j) {
                let takingUnit = j["takingUnit"];
                if (takingUnit !== null) {
                    let parentItem = $("[lay-id='currentTableForMaterial'] tr:eq(" + (i + 1) + ")");
                    let unitHandleItem = parentItem.children()[6];
                    let quantityHandleItem = parentItem.children()[7];
                    unitHandleItem.childNodes[0].childNodes[1].childNodes[0].data = takingUnit;
                    quantityHandleItem.childNodes[0].innerText = j["splitInventory"][takingUnit];
                }
            });
        }
    });




    // 用于打开负责人树形菜单
    $("#selectdepartmentManagerForMaterial").on('click', function () {
        layer.open({
            type: 2,
            title: '弹窗内容',
            skin: 'layui-layer-rim',
            maxmin: true,
            shadeClose: true, //点击遮罩关闭层
            area: ['70%', '70%'],
            move: '.layui-layer-title',
            fixed: false,
            content: '/selectManager?type=Material',
            end: function () {
                departmentManagerIdForMaterial = $("#departmentManagerIdForMaterial").val();
                tagLabel.createItem();
            },
            success: function (layero, index) {
                var children = layero.children();
                var content = $(children[1]);
                var iframeChildren = $(content.children());
                content.css('height', '100%');
                iframeChildren.css('height', '100%');
            }
        });
    });






    table.on('edit(currentTableFilterForMaterial)', function (obj) {
        obj.update({stockTakingQuantity: obj.value});//修改当前行数据
        calculateForMaterial(obj);
    });
    // 用于监听下拉菜单
    table.on('tool(currentTableFilterForMaterial)', function (obj) { //注：tool 是工具条事件名，test 是 table 原始容器的属性 lay-filter="对应的值"
        var data = obj.data //获得当前行数据
            , layEvent = obj.event; //获得 lay-event 对应的值
        if (layEvent === 'more') {
            let splitInfoList = obj.data.splitInfoList;
            if (splitInfoList.length > 0) {
                let dropDownDataList = [];
                for (var i = 0; i < splitInfoList.length; i++) {
                    let dropDownData = {};
                    dropDownData.title = splitInfoList[i].newUnit;
                    dropDownData.id = obj.data.id;
                    dropDownDataList.push(dropDownData);
                }
                dropdown.render({
                    elem: this //触发事件的 DOM 对象
                    , show: true //外部事件触发即显示
                    , data: dropDownDataList
                    , click: function (unit) {
                        this.elem[0].childNodes[0].data = unit.title;
                        obj.tr[0].childNodes[7].childNodes[0].innerText = obj.data.splitInventory[unit.title];
                    }
                    , align: 'right' //右对齐弹出（v2.6.8 新增）
                    , style: 'box-shadow: 1px 1px 10px rgb(0 0 0 / 12%);' //设置额外样式
                })
            }
            //下拉菜单

        }
        else if(layEvent === "clear"){
            let req = {};
            req.id = obj.data.id + "";
            $.ajax({
                url: "/stockTaking/delTemporaryStorageForTakingResult",
                dataType: "json",
                data: JSON.stringify(req),
                type: "POST",
                contentType: "application/json;charset=utf-8",
                success : function(){
                    updateTableShowForMaterial();
                }
            });
        }
    });

    // 用于计算盘点结果
    calculateForMaterial = function (obj) {
        let oldInventory = Number(obj.tr[0].childNodes[7].childNodes[0].innerText);
        let nowInventory = Number(obj.value);
        let number = 0;
        let takingResult = '';
        let takingResultString = '';
        let req = {};
        if ((oldInventory) > (nowInventory)) {
            number = oldInventory - nowInventory;
            takingResult = "Inventory_down";
            takingResultString = "盘亏";
        } else if ((oldInventory) < (nowInventory)) {
            number = nowInventory - oldInventory;
            takingResult = "Inventory_up";
            takingResultString = "盘盈";
        } else {
            takingResult = "Inventory_normal";
            takingResultString = "正常";
        }
        obj.tr[0].childNodes[9].childNodes[0].innerText = takingResultString;
        obj.tr[0].childNodes[10].childNodes[0].innerText = number;
        obj.update({takingResult: takingResult});
        obj.update({takingInventory: number});
        req.number = number + "";
        req.takingResult = takingResult;
        req.takingResultString = takingResultString;
        req.id = obj.data.id + "";
        req.unit = obj.tr[0].childNodes[6].childNodes[0].innerText;
        req.oldInventory = oldInventory + "";
        $.ajax({
            url: "/stockTaking/temporaryStorageForTakingResult",
            dataType: "json",
            data: JSON.stringify(req),
            type: "POST",
            contentType: "application/json;charset=utf-8"
        });
    };

    // 用于通过物料名称获取物料
    selectMaterialByName = function (obj) {
        // 输入code
        var data = obj.value;
        var req = {};
        data = data.split(",")[0];
        if (data !== "") {
            req.mname = data;
            $.ajax({
                url: "/material/findMaterialByCondition",
                type: "post",
                dataType: 'json',
                data: JSON.stringify(req),
                contentType: "application/json;charset=utf-8",
                success: function (d) {
                    if (d.count > 1) {
                        layer.msg("请点击右侧搜索确定物品");
                        $("#mname").val("");
                        $("#mid").val("");
                        $("#code").val("");
                        return false;
                    } else if (d.count === 0) {
                        layer.msg("没有该物品，请确认输入是否正确");
                        $("#mname").val("");
                        $("#mid").val("");
                        $("#code").val("");
                        return false;
                    } else {
                        var material = d.data[0];
                        $("#mname").val(material.mname);
                        $("#mid").val(material.mid);
                        $("#code").val(material.code);
                        form.render();
                        updateTableShowForMaterial();
                    }
                }
            });
        }

    };


    // 用于实现通过编码查询物料
    selectCode = function (obj) {
        // 输入code
        var code = obj.value;
        var req = {};
        req.code = code;
        req.type = "out";
        if (code !== "") {
            $.ajax({
                url: "/material/findMatrialByCode",
                type: "get",
                dataType: 'json',
                data: (req),
                contentType: "application/json;charset=utf-8",
                success: function (d) {
                    var d = d.data;
                    if (d == null) {
                        layer.msg("仓库中暂无该物料", {
                            icon: 0,
                            time: 1000
                        }, function () {
                            $("#mname").val("");
                            $("#mid").val("");
                            $("#code").val("");
                            updateTableShowForMaterial();
                        });

                    } else {
                        $("#mname").val(d.mname);
                        $("#mid").val(d.mid);
                        form.render();
                        updateTableShowForMaterial();

                    }
                }
            });
        }

    };


    scanCodeForMaterial = function () {
        let wxScan = parent;

        if (wxScan.wx === undefined) {
            wxScan = wxScan.parent.wx;
        } else {
            wxScan = wxScan.wx;
        }
        wxScan.scanQRCode({
            desc: 'scanQRCode desc',
            needResult: 1, // 默认为0，扫描结果由企业微信处理，1则直接返回扫描结果，
            scanType: ["qrCode", "barCode"], // 可以指定扫二维码还是条形码（一维码），默认二者都有
            success: function (res) {
                // 回调
                var result = res.resultStr;//当needResult为1时返回处理结果
                var req = {};
                req.qrCode = result;
                req.codeFlag = 2;
                $.ajax({
                    url: "/material/qywxApplicationOutScanQrCode",
                    type: "post",
                    dataType: 'json',
                    data: JSON.stringify(req),
                    contentType: "application/json;charset=utf-8",
                    success: function (d) {
                        var data = d.data;
                        if (data === null) {
                            layer.msg("对于编码：" + result + ",并未发现仓库中存在对应的物料", {
                                icon: 0,
                                time: 1000 //0.5秒关闭（如果不配置，默认是3秒）
                            }, function () {
                                $("#mname").val("");
                                $("#mid").val("");
                                $("#code").val("");
                                updateTableShowForMaterial();
                            })
                        } else {
                            $("#mname").val(data.mname);
                            $("#mid").val(data.id);
                            $("#code").val(data.code);
                            updateTableShowForMaterial();
                        }
                    }
                })
            }
        })
    };


});
