/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsr310.deser;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.datatype.jsr310.DecimalUtils;
import com.fasterxml.jackson.datatype.jsr310.deser.JSR310DeserializerBase;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.DateTimeException;
import java.time.Duration;

public class DurationDeserializer
extends JSR310DeserializerBase<Duration>
implements ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    public static final DurationDeserializer INSTANCE = new DurationDeserializer();

    private DurationDeserializer() {
        super(Duration.class);
    }

    protected DurationDeserializer(DurationDeserializer base, Boolean leniency) {
        super(base, leniency);
    }

    protected DurationDeserializer withLeniency(Boolean leniency) {
        return new DurationDeserializer(this, leniency);
    }

    public Duration deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        switch (parser.getCurrentTokenId()) {
            case 8: {
                BigDecimal value = parser.getDecimalValue();
                return DecimalUtils.extractSecondsAndNanos(value, Duration::ofSeconds);
            }
            case 7: {
                if (context.isEnabled(DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS)) {
                    return Duration.ofSeconds(parser.getLongValue());
                }
                return Duration.ofMillis(parser.getLongValue());
            }
            case 6: {
                String string = parser.getText().trim();
                if (string.length() == 0) {
                    if (!this.isLenient()) {
                        return (Duration)this._failForNotLenient(parser, context, JsonToken.VALUE_STRING);
                    }
                    return null;
                }
                try {
                    return Duration.parse(string);
                }
                catch (DateTimeException e) {
                    return (Duration)this._handleDateTimeException(context, e, string);
                }
            }
            case 12: {
                return (Duration)parser.getEmbeddedObject();
            }
            case 3: {
                return (Duration)this._deserializeFromArray(parser, context);
            }
        }
        return (Duration)this._handleUnexpectedToken(context, parser, JsonToken.VALUE_STRING, JsonToken.VALUE_NUMBER_INT, JsonToken.VALUE_NUMBER_FLOAT);
    }

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        Boolean leniency;
        JsonFormat.Value format = this.findFormatOverrides(ctxt, property, this.handledType());
        DurationDeserializer deser = this;
        if (format != null && format.hasLenient() && (leniency = format.getLenient()) != null) {
            deser = deser.withLeniency(leniency);
        }
        return deser;
    }
}

