/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLDataTypeImpl;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLCaseExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntervalExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLNullExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumericLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLCharacterDataType;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.OracleWithSubqueryEntry;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleSysdateExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectJoin;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectQueryBlock;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectSubqueryTableSource;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectTableReference;
import com.alibaba.druid.util.FnvHash;
import java.util.List;

public class SQLTransformUtils {
    public static SQLExpr transformDecode(SQLMethodInvokeExpr x) {
        if (x == null) {
            return null;
        }
        if (!"decode".equalsIgnoreCase(x.getMethodName())) {
            throw new IllegalArgumentException(x.getMethodName());
        }
        List<SQLExpr> parameters = x.getParameters();
        SQLCaseExpr caseExpr = new SQLCaseExpr();
        caseExpr.setParent(x.getParent());
        caseExpr.setValueExpr(parameters.get(0));
        if (parameters.size() == 4) {
            SQLExpr param1 = parameters.get(1);
            x.setMethodName("if");
            SQLBinaryOpExpr condition = param1 instanceof SQLNullExpr ? new SQLBinaryOpExpr(parameters.get(0), SQLBinaryOperator.Is, param1) : new SQLBinaryOpExpr(parameters.get(0), SQLBinaryOperator.Equality, param1);
            condition.setParent(x);
            parameters.set(0, condition);
            parameters.set(1, parameters.get(2));
            parameters.set(2, parameters.get(3));
            parameters.remove(3);
            return x;
        }
        int i = 1;
        while (i + 1 < parameters.size()) {
            SQLMethodInvokeExpr methodInvokeExpr;
            SQLCaseExpr.Item item = new SQLCaseExpr.Item();
            SQLExpr conditionExpr = parameters.get(i);
            item.setConditionExpr(conditionExpr);
            SQLExpr valueExpr = parameters.get(i + 1);
            if (valueExpr instanceof SQLMethodInvokeExpr && "decode".equalsIgnoreCase((methodInvokeExpr = (SQLMethodInvokeExpr)valueExpr).getMethodName())) {
                valueExpr = SQLTransformUtils.transformDecode(methodInvokeExpr);
            }
            item.setValueExpr(valueExpr);
            caseExpr.addItem(item);
            i += 2;
        }
        if (parameters.size() % 2 == 0) {
            SQLMethodInvokeExpr methodInvokeExpr;
            SQLExpr defaultExpr = parameters.get(parameters.size() - 1);
            if (defaultExpr instanceof SQLMethodInvokeExpr && "decode".equalsIgnoreCase((methodInvokeExpr = (SQLMethodInvokeExpr)defaultExpr).getMethodName())) {
                defaultExpr = SQLTransformUtils.transformDecode(methodInvokeExpr);
            }
            caseExpr.setElseExpr(defaultExpr);
        }
        caseExpr.setParent(x.getParent());
        return caseExpr;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SQLDataType transformOracleToMySql(SQLDataType x) {
        SQLDataType dataType;
        String name = x.getName();
        long nameHash = x.nameHashCode64();
        if (name == null) {
            return x;
        }
        List<SQLExpr> argumentns = x.getArguments();
        if (nameHash == FnvHash.Constants.UROWID) {
            SQLExpr arg0;
            int len = 4000;
            if (argumentns.size() == 1 && (arg0 = argumentns.get(0)) instanceof SQLIntegerExpr) {
                len = ((SQLIntegerExpr)arg0).getNumber().intValue();
            }
            dataType = new SQLDataTypeImpl("varchar", len);
        } else if (nameHash == FnvHash.Constants.ROWID) {
            dataType = new SQLDataTypeImpl("char", 10);
        } else if (nameHash == FnvHash.Constants.BOOLEAN) {
            dataType = new SQLDataTypeImpl("tinyint");
        } else if (nameHash == FnvHash.Constants.INTEGER) {
            dataType = new SQLDataTypeImpl("int");
        } else if (nameHash == FnvHash.Constants.FLOAT || nameHash == FnvHash.Constants.BINARY_FLOAT) {
            dataType = new SQLDataTypeImpl("float");
        } else if (nameHash == FnvHash.Constants.REAL || nameHash == FnvHash.Constants.BINARY_DOUBLE || nameHash == FnvHash.Constants.DOUBLE_PRECISION) {
            dataType = new SQLDataTypeImpl("double");
        } else if (nameHash == FnvHash.Constants.NUMBER) {
            if (argumentns.size() == 0) {
                dataType = new SQLDataTypeImpl("decimal", 38);
            } else {
                SQLExpr arg0 = argumentns.get(0);
                int scale = 0;
                int precision = arg0 instanceof SQLAllColumnExpr ? 9 : ((SQLIntegerExpr)arg0).getNumber().intValue();
                if (argumentns.size() > 1) {
                    scale = ((SQLIntegerExpr)argumentns.get(1)).getNumber().intValue();
                }
                if (scale > precision) {
                    if (arg0 instanceof SQLAllColumnExpr) {
                        precision = 19;
                        if (scale > precision) {
                            precision = scale;
                        }
                    } else {
                        precision = scale;
                    }
                }
                dataType = scale == 0 ? (precision < 3 ? new SQLDataTypeImpl("tinyint") : (precision < 5 ? new SQLDataTypeImpl("smallint") : (precision < 9 ? new SQLDataTypeImpl("int") : (precision <= 20 ? new SQLDataTypeImpl("bigint") : new SQLDataTypeImpl("decimal", precision))))) : new SQLDataTypeImpl("decimal", precision, scale);
            }
        } else if (nameHash == FnvHash.Constants.DEC || nameHash == FnvHash.Constants.DECIMAL) {
            dataType = x.clone();
            dataType.setName("decimal");
            int precision = 0;
            if (argumentns.size() > 0) {
                precision = ((SQLIntegerExpr)argumentns.get(0)).getNumber().intValue();
            }
            int scale = 0;
            if (argumentns.size() > 1 && precision < (scale = ((SQLIntegerExpr)argumentns.get(1)).getNumber().intValue())) {
                ((SQLIntegerExpr)dataType.getArguments().get(1)).setNumber(precision);
            }
        } else if (nameHash == FnvHash.Constants.RAW) {
            int len;
            if (argumentns.size() == 0) {
                len = -1;
            } else {
                if (argumentns.size() != 1) throw new UnsupportedOperationException(SQLUtils.toOracleString(x));
                SQLExpr arg0 = argumentns.get(0);
                if (!(arg0 instanceof SQLNumericLiteralExpr)) throw new UnsupportedOperationException(SQLUtils.toOracleString(x));
                len = ((SQLNumericLiteralExpr)arg0).getNumber().intValue();
            }
            dataType = len == -1 ? new SQLDataTypeImpl("binary") : (len <= 255 ? new SQLDataTypeImpl("binary", len) : new SQLDataTypeImpl("varbinary", len));
        } else if (nameHash == FnvHash.Constants.CHAR || nameHash == FnvHash.Constants.CHARACTER) {
            if (argumentns.size() == 1) {
                SQLExpr arg0 = argumentns.get(0);
                if (!(arg0 instanceof SQLNumericLiteralExpr)) {
                    throw new UnsupportedOperationException(SQLUtils.toOracleString(x));
                }
                int len = ((SQLNumericLiteralExpr)arg0).getNumber().intValue();
                dataType = len <= 255 ? new SQLCharacterDataType("char", len) : new SQLCharacterDataType("varchar", len);
            } else {
                if (argumentns.size() != 0) throw new UnsupportedOperationException(SQLUtils.toOracleString(x));
                dataType = new SQLCharacterDataType("char");
            }
        } else if (nameHash == FnvHash.Constants.NCHAR) {
            if (argumentns.size() == 1) {
                SQLExpr arg0 = argumentns.get(0);
                if (!(arg0 instanceof SQLNumericLiteralExpr)) {
                    throw new UnsupportedOperationException(SQLUtils.toOracleString(x));
                }
                int len = ((SQLNumericLiteralExpr)arg0).getNumber().intValue();
                dataType = len <= 255 ? new SQLCharacterDataType("nchar", len) : new SQLCharacterDataType("nvarchar", len);
            } else {
                if (argumentns.size() != 0) throw new UnsupportedOperationException(SQLUtils.toOracleString(x));
                dataType = new SQLCharacterDataType("nchar");
            }
        } else if (nameHash == FnvHash.Constants.VARCHAR2) {
            if (argumentns.size() > 0) {
                SQLExpr arg0 = argumentns.get(0);
                if (!(arg0 instanceof SQLNumericLiteralExpr)) {
                    throw new UnsupportedOperationException(SQLUtils.toOracleString(x));
                }
                int len = ((SQLNumericLiteralExpr)arg0).getNumber().intValue();
                dataType = new SQLCharacterDataType("varchar", len);
            } else {
                dataType = new SQLCharacterDataType("varchar");
            }
        } else if (nameHash == FnvHash.Constants.NVARCHAR2) {
            if (argumentns.size() > 0) {
                SQLExpr arg0 = argumentns.get(0);
                if (!(arg0 instanceof SQLNumericLiteralExpr)) {
                    throw new UnsupportedOperationException(SQLUtils.toOracleString(x));
                }
                int len = ((SQLNumericLiteralExpr)arg0).getNumber().intValue();
                dataType = new SQLCharacterDataType("nvarchar", len);
            } else {
                dataType = new SQLCharacterDataType("nvarchar");
            }
        } else if (nameHash == FnvHash.Constants.BFILE) {
            dataType = new SQLCharacterDataType("varchar", 255);
        } else if (nameHash == FnvHash.Constants.DATE || nameHash == FnvHash.Constants.TIMESTAMP) {
            int len = -1;
            if (argumentns.size() > 0) {
                SQLExpr arg0 = argumentns.get(0);
                if (!(arg0 instanceof SQLNumericLiteralExpr)) throw new UnsupportedOperationException(SQLUtils.toOracleString(x));
                len = ((SQLNumericLiteralExpr)arg0).getNumber().intValue();
            }
            if (len >= 0) {
                if (len > 6) {
                    len = 6;
                }
                dataType = new SQLDataTypeImpl("datetime", len);
            } else {
                dataType = new SQLDataTypeImpl("datetime");
            }
        } else if (nameHash == FnvHash.Constants.BLOB || nameHash == FnvHash.Constants.LONG_RAW) {
            argumentns.clear();
            dataType = new SQLDataTypeImpl("LONGBLOB");
        } else if (nameHash == FnvHash.Constants.CLOB || nameHash == FnvHash.Constants.NCLOB || nameHash == FnvHash.Constants.LONG || nameHash == FnvHash.Constants.XMLTYPE) {
            argumentns.clear();
            dataType = new SQLCharacterDataType("LONGTEXT");
        } else {
            dataType = x;
        }
        if (dataType == x) return dataType;
        dataType.setParent(x.getParent());
        return dataType;
    }

    public static SQLDataType transformOracleToAliyunAds(SQLDataType x) {
        SQLDataType dataType;
        String dataTypeName = x.getName().toLowerCase();
        if (dataTypeName.equals("varchar2") || dataTypeName.equals("varchar") || dataTypeName.equals("char") || dataTypeName.equals("nchar") || dataTypeName.equals("nvarchar") || dataTypeName.equals("nvarchar2") || dataTypeName.equals("clob") || dataTypeName.equals("nclob") || dataTypeName.equals("blob") || dataTypeName.equals("long") || dataTypeName.equals("long raw") || dataTypeName.equals("raw")) {
            dataType = new SQLCharacterDataType("varchar");
        } else if (dataTypeName.equals("number") || dataTypeName.equals("decimal") || dataTypeName.equals("dec") || dataTypeName.equals("numeric")) {
            int scale = 0;
            if (x.getArguments().size() > 1) {
                scale = ((SQLIntegerExpr)x.getArguments().get(1)).getNumber().intValue();
            }
            dataType = scale == 0 ? new SQLDataTypeImpl("bigint") : new SQLDataTypeImpl("double");
        } else {
            dataType = dataTypeName.equals("date") || dataTypeName.equals("datetime") || dataTypeName.equals("timestamp") ? new SQLDataTypeImpl("timestamp") : (dataTypeName.equals("float") || dataTypeName.equals("binary_float") ? new SQLDataTypeImpl("float") : (dataTypeName.equals("double") || dataTypeName.equals("binary_double") ? new SQLDataTypeImpl("double") : x));
        }
        if (dataType != x) {
            dataType.setParent(x.getParent());
        }
        return dataType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SQLDataType transformOracleToPostgresql(SQLDataType x) {
        SQLDataType dataType;
        String name = x.getName();
        long nameHash = x.nameHashCode64();
        if (name == null) {
            return x;
        }
        List<SQLExpr> argumentns = x.getArguments();
        if (nameHash == FnvHash.Constants.UROWID) {
            SQLExpr arg0;
            int len = 4000;
            if (argumentns.size() == 1 && (arg0 = argumentns.get(0)) instanceof SQLIntegerExpr) {
                len = ((SQLIntegerExpr)arg0).getNumber().intValue();
            }
            dataType = new SQLDataTypeImpl("VARCHAR", len);
        } else if (nameHash == FnvHash.Constants.ROWID) {
            dataType = new SQLDataTypeImpl("CHAR", 10);
        } else if (nameHash == FnvHash.Constants.BOOLEAN || nameHash == FnvHash.Constants.SMALLINT) {
            dataType = new SQLDataTypeImpl("SMALLINT");
        } else if (nameHash == FnvHash.Constants.INTEGER || nameHash == FnvHash.Constants.INT) {
            dataType = new SQLDataTypeImpl("DECIMAL", 38);
        } else if (nameHash == FnvHash.Constants.BINARY_FLOAT) {
            dataType = new SQLDataTypeImpl("REAL");
        } else if (nameHash == FnvHash.Constants.BINARY_DOUBLE || nameHash == FnvHash.Constants.FLOAT || nameHash == FnvHash.Constants.DOUBLE || nameHash == FnvHash.Constants.REAL || nameHash == FnvHash.Constants.DOUBLE_PRECISION) {
            dataType = new SQLDataTypeImpl("DOUBLE PRECISION");
        } else if (nameHash == FnvHash.Constants.NUMBER) {
            if (argumentns.size() == 0) {
                dataType = new SQLDataTypeImpl("DECIMAL", 38);
            } else {
                int precision;
                SQLExpr arg0 = argumentns.get(0);
                int scale = 0;
                if (arg0 instanceof SQLAllColumnExpr) {
                    precision = 19;
                    scale = -1;
                } else {
                    precision = ((SQLIntegerExpr)arg0).getNumber().intValue();
                }
                if (argumentns.size() > 1) {
                    scale = ((SQLIntegerExpr)argumentns.get(1)).getNumber().intValue();
                }
                if (scale > precision) {
                    if (arg0 instanceof SQLAllColumnExpr) {
                        precision = 19;
                        if (scale > precision) {
                            precision = scale;
                        }
                    } else {
                        precision = scale;
                    }
                }
                dataType = scale == 0 ? (precision < 5 ? new SQLDataTypeImpl("SMALLINT") : (precision < 9 ? new SQLDataTypeImpl("INT") : (precision <= 20 ? new SQLDataTypeImpl("BIGINT") : new SQLDataTypeImpl("DECIMAL", precision)))) : (scale == -1 ? new SQLDataTypeImpl("DOUBLE PRECISION") : new SQLDataTypeImpl("DECIMAL", precision, scale));
            }
        } else if (nameHash == FnvHash.Constants.DEC || nameHash == FnvHash.Constants.DECIMAL) {
            dataType = x.clone();
            dataType.setName("DECIMAL");
            int precision = 0;
            if (argumentns.size() > 0) {
                precision = ((SQLIntegerExpr)argumentns.get(0)).getNumber().intValue();
            }
            int scale = 0;
            if (argumentns.size() > 1 && precision < (scale = ((SQLIntegerExpr)argumentns.get(1)).getNumber().intValue())) {
                ((SQLIntegerExpr)dataType.getArguments().get(1)).setNumber(precision);
            }
        } else if (nameHash == FnvHash.Constants.CHARACTER) {
            if (argumentns.size() == 1) {
                SQLExpr arg0 = argumentns.get(0);
                if (!(arg0 instanceof SQLNumericLiteralExpr)) {
                    throw new UnsupportedOperationException(SQLUtils.toOracleString(x));
                }
                int len = ((SQLNumericLiteralExpr)arg0).getNumber().intValue();
                dataType = new SQLCharacterDataType("CHAR", len);
            } else {
                if (argumentns.size() != 0) throw new UnsupportedOperationException(SQLUtils.toOracleString(x));
                dataType = new SQLCharacterDataType("CHAR");
            }
        } else if (nameHash == FnvHash.Constants.CHAR) {
            if (argumentns.size() == 1) {
                SQLExpr arg0 = argumentns.get(0);
                if (!(arg0 instanceof SQLNumericLiteralExpr)) {
                    throw new UnsupportedOperationException(SQLUtils.toOracleString(x));
                }
                int len = ((SQLNumericLiteralExpr)arg0).getNumber().intValue();
                if (len <= 2000) {
                    dataType = x;
                    dataType.setName("CHAR");
                } else {
                    dataType = new SQLCharacterDataType("TEXT");
                }
            } else {
                if (argumentns.size() != 0) throw new UnsupportedOperationException(SQLUtils.toOracleString(x));
                dataType = new SQLCharacterDataType("CHAR");
            }
        } else if (nameHash == FnvHash.Constants.NCHAR) {
            dataType = x;
            dataType.setName("NCHAR");
        } else if (nameHash == FnvHash.Constants.VARCHAR || nameHash == FnvHash.Constants.VARCHAR2) {
            if (argumentns.size() > 0) {
                int len;
                SQLExpr arg0 = argumentns.get(0);
                if (arg0 instanceof SQLNumericLiteralExpr) {
                    len = ((SQLNumericLiteralExpr)arg0).getNumber().intValue();
                } else {
                    if (!(arg0 instanceof SQLVariantRefExpr)) throw new UnsupportedOperationException(SQLUtils.toOracleString(x));
                    len = 2000;
                }
                dataType = len <= 4000 ? new SQLCharacterDataType("VARCHAR", len) : new SQLCharacterDataType("TEXT");
            } else {
                dataType = new SQLCharacterDataType("VARCHAR");
            }
        } else if (nameHash == FnvHash.Constants.NVARCHAR || nameHash == FnvHash.Constants.NVARCHAR2 || nameHash == FnvHash.Constants.NCHAR_VARYING) {
            if (argumentns.size() > 0) {
                SQLExpr arg0 = argumentns.get(0);
                if (!(arg0 instanceof SQLNumericLiteralExpr)) {
                    throw new UnsupportedOperationException(SQLUtils.toOracleString(x));
                }
                int len = ((SQLNumericLiteralExpr)arg0).getNumber().intValue();
                dataType = new SQLCharacterDataType("VARCHAR", len);
            } else {
                dataType = new SQLCharacterDataType("VARCHAR");
            }
        } else if (nameHash == FnvHash.Constants.BFILE) {
            dataType = new SQLCharacterDataType("VARCHAR", 255);
        } else if (nameHash == FnvHash.Constants.DATE) {
            dataType = new SQLDataTypeImpl("TIMESTAMP", 0);
        } else if (nameHash == FnvHash.Constants.TIMESTAMP) {
            x.setName("TIMESTAMP");
            if (x.isWithLocalTimeZone()) {
                x.setWithLocalTimeZone(false);
                x.setWithTimeZone(null);
            }
            dataType = x;
        } else if (nameHash == FnvHash.Constants.DATETIME) {
            int len = -1;
            if (argumentns.size() > 0) {
                SQLExpr arg0 = argumentns.get(0);
                if (!(arg0 instanceof SQLNumericLiteralExpr)) throw new UnsupportedOperationException(SQLUtils.toOracleString(x));
                len = ((SQLNumericLiteralExpr)arg0).getNumber().intValue();
            }
            dataType = len > 0 ? new SQLDataTypeImpl("TIMESTAMP", len) : new SQLDataTypeImpl("TIMESTAMP");
        } else if (nameHash == FnvHash.Constants.BLOB || nameHash == FnvHash.Constants.LONG_RAW || nameHash == FnvHash.Constants.RAW) {
            argumentns.clear();
            dataType = new SQLDataTypeImpl("BYTEA");
        } else if (nameHash == FnvHash.Constants.CLOB || nameHash == FnvHash.Constants.NCLOB || nameHash == FnvHash.Constants.LONG) {
            argumentns.clear();
            dataType = new SQLCharacterDataType("TEXT");
        } else {
            dataType = nameHash == FnvHash.Constants.XMLTYPE ? new SQLDataTypeImpl("XML") : x;
        }
        if (dataType == x) return dataType;
        dataType.setParent(x.getParent());
        return dataType;
    }

    public static SQLExpr transformOracleToPostgresql(SQLMethodInvokeExpr x) {
        String text;
        SQLExpr param0;
        long nameHashCode64 = x.methodNameHashCode64();
        List<SQLExpr> parameters = x.getParameters();
        if (nameHashCode64 == FnvHash.Constants.SYS_GUID) {
            SQLMethodInvokeExpr uuid_generate_v4 = new SQLMethodInvokeExpr("uuid_generate_v4");
            uuid_generate_v4.setParent(x.getParent());
            return uuid_generate_v4;
        }
        if (nameHashCode64 == FnvHash.Constants.TRUNC && parameters.size() == 1 && ((param0 = parameters.get(0)) instanceof OracleSysdateExpr || param0 instanceof SQLIdentifierExpr && ((SQLIdentifierExpr)param0).nameHashCode64() == FnvHash.Constants.CURRENT_TIMESTAMP)) {
            SQLMethodInvokeExpr current_timestamp = new SQLMethodInvokeExpr("CURRENT_TIMESTAMP");
            current_timestamp.addParameter(new SQLIntegerExpr(0));
            current_timestamp.setParent(x.getParent());
            return current_timestamp;
        }
        if (nameHashCode64 == FnvHash.Constants.CURRENT_TIMESTAMP && parameters.size() == 0 && x.getParent() instanceof SQLColumnDefinition) {
            SQLDataType dataType = ((SQLColumnDefinition)x.getParent()).getDataType();
            if (dataType.nameHashCode64() == FnvHash.Constants.TIMESTAMP && dataType.getArguments().size() == 1) {
                x.addParameter(dataType.getArguments().get(0).clone());
            } else {
                x.addParameter(new SQLIntegerExpr(0));
            }
            return x;
        }
        if (nameHashCode64 == FnvHash.Constants.SYSTIMESTAMP) {
            SQLMethodInvokeExpr xx = x.clone();
            xx.setMethodName("CURRENT_TIMESTAMP");
            xx.setParent(x.getParent());
            return xx;
        }
        if (nameHashCode64 == FnvHash.Constants.USERENV && x.getParameters().size() == 1 && (param0 = x.getParameters().get(0)) instanceof SQLCharExpr && "SESSIONID".equalsIgnoreCase(text = ((SQLCharExpr)param0).getText())) {
            SQLMethodInvokeExpr xx = new SQLMethodInvokeExpr();
            xx.setMethodName("get_session_id");
            xx.setParent(x.getParent());
            return xx;
        }
        if (nameHashCode64 == FnvHash.Constants.USERENV && x.getParameters().size() == 1 && (param0 = x.getParameters().get(0)) instanceof SQLCharExpr && "SESSIONID".equalsIgnoreCase(text = ((SQLCharExpr)param0).getText())) {
            SQLMethodInvokeExpr xx = new SQLMethodInvokeExpr();
            xx.setMethodName("get_session_id");
            xx.setParent(x.getParent());
            return xx;
        }
        if (nameHashCode64 == FnvHash.Constants.NUMTODSINTERVAL && x.getParameters().size() == 2) {
            String text2;
            param0 = x.getParameters().get(0);
            SQLExpr param1 = x.getParameters().get(1);
            if (param0 instanceof SQLIntegerExpr && param1 instanceof SQLCharExpr && "DAY".equalsIgnoreCase(text2 = ((SQLCharExpr)param1).getText())) {
                SQLIntervalExpr intervalExpr = new SQLIntervalExpr();
                intervalExpr.setValue(new SQLCharExpr(param0.toString() + " DAYS"));
                intervalExpr.setParent(x.getParent());
                return intervalExpr;
            }
        }
        return x;
    }

    public static SQLTableSource transformOracleToPostgresql(SQLTableSource x) {
        if (x instanceof OracleSelectTableReference) {
            OracleSelectTableReference xx = (OracleSelectTableReference)x;
            SQLExprTableSource y = new SQLExprTableSource();
            xx.cloneTo(y);
            y.setParent(x.getParent());
            return y;
        }
        if (x instanceof OracleSelectJoin) {
            OracleSelectJoin xx = (OracleSelectJoin)x;
            SQLJoinTableSource y = new SQLJoinTableSource();
            xx.cloneTo(y);
            y.setLeft(SQLTransformUtils.transformOracleToPostgresql(y.getLeft()));
            y.setRight(SQLTransformUtils.transformOracleToPostgresql(y.getRight()));
            y.setParent(x.getParent());
            return y;
        }
        if (x instanceof OracleSelectSubqueryTableSource) {
            OracleSelectSubqueryTableSource xx = (OracleSelectSubqueryTableSource)x;
            SQLSubqueryTableSource y = new SQLSubqueryTableSource();
            xx.cloneTo(y);
            y.setParent(x.getParent());
            return y;
        }
        if (x instanceof OracleWithSubqueryEntry) {
            SQLWithSubqueryClause.Entry entry = new SQLWithSubqueryClause.Entry();
            ((OracleWithSubqueryEntry)x).cloneTo(entry);
            entry.setParent(x.getParent());
            return entry;
        }
        return x;
    }

    public static SQLSelectQueryBlock transformOracleToPostgresql(SQLSelectQueryBlock x) {
        if (x instanceof OracleSelectQueryBlock) {
            OracleSelectQueryBlock xx = (OracleSelectQueryBlock)x;
            SQLSelectQueryBlock y = new SQLSelectQueryBlock();
            xx.cloneTo(y);
            y.setFrom(SQLTransformUtils.transformOracleToPostgresql(y.getFrom()));
            y.setParent(x.getParent());
            return y;
        }
        return x;
    }
}

