/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.templateparser.raw;

public final class RawParseException
extends Exception {
    private static final long serialVersionUID = -104133072151159140L;
    private final Integer line;
    private final Integer col;

    public RawParseException() {
        this.line = null;
        this.col = null;
    }

    public RawParseException(String message, Throwable throwable) {
        super(RawParseException.message(message, throwable), throwable);
        if (throwable != null && throwable instanceof RawParseException) {
            this.line = ((RawParseException)throwable).getLine();
            this.col = ((RawParseException)throwable).getCol();
        } else {
            this.line = null;
            this.col = null;
        }
    }

    public RawParseException(String message) {
        super(message);
        this.line = null;
        this.col = null;
    }

    public RawParseException(Throwable throwable) {
        super(RawParseException.message(null, throwable), throwable);
        if (throwable != null && throwable instanceof RawParseException) {
            this.line = ((RawParseException)throwable).getLine();
            this.col = ((RawParseException)throwable).getCol();
        } else {
            this.line = null;
            this.col = null;
        }
    }

    public RawParseException(int line, int col) {
        super(RawParseException.messagePrefix(line, col));
        this.line = line;
        this.col = col;
    }

    public RawParseException(String message, Throwable throwable, int line, int col) {
        super(RawParseException.messagePrefix(line, col) + " " + message, throwable);
        this.line = line;
        this.col = col;
    }

    public RawParseException(String message, int line, int col) {
        super(RawParseException.messagePrefix(line, col) + " " + message);
        this.line = line;
        this.col = col;
    }

    public RawParseException(Throwable throwable, int line, int col) {
        super(RawParseException.messagePrefix(line, col), throwable);
        this.line = line;
        this.col = col;
    }

    private static String messagePrefix(int line, int col) {
        return "(Line = " + line + ", Column = " + col + ")";
    }

    private static String message(String message, Throwable throwable) {
        RawParseException exception;
        if (throwable != null && throwable instanceof RawParseException && (exception = (RawParseException)throwable).getLine() != null && exception.getCol() != null) {
            return "(Line = " + exception.getLine() + ", Column = " + exception.getCol() + ")" + (message != null ? " " + message : throwable.getMessage());
        }
        if (message != null) {
            return message;
        }
        if (throwable != null) {
            return throwable.getMessage();
        }
        return null;
    }

    public Integer getLine() {
        return this.line;
    }

    public Integer getCol() {
        return this.col;
    }
}

