/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.util.Strings;

public class ElementsShouldSatisfy
extends BasicErrorMessageFactory {
    public static ErrorMessageFactory elementsShouldSatisfyAny(Object actual, List<UnsatisfiedRequirement> elementsNotSatisfyingRequirements, AssertionInfo info) {
        return new ElementsShouldSatisfy("%nExpecting any element of:%n  <%s>%nto satisfy the given assertions requirements but none did:%n%n", actual, elementsNotSatisfyingRequirements, info);
    }

    public static ErrorMessageFactory elementsShouldSatisfy(Object actual, List<UnsatisfiedRequirement> elementsNotSatisfyingRestrictions, AssertionInfo info) {
        return new ElementsShouldSatisfy("%nExpecting all elements of:%n  <%s>%nto satisfy given requirements, but these elements did not:%n%n", actual, elementsNotSatisfyingRestrictions, info);
    }

    private ElementsShouldSatisfy(String message, Object actual, List<UnsatisfiedRequirement> elementsNotSatisfyingRequirements, AssertionInfo info) {
        super(message + ElementsShouldSatisfy.describeErrors(elementsNotSatisfyingRequirements, info), actual);
    }

    private static String describeErrors(List<UnsatisfiedRequirement> elementsNotSatisfyingRequirements, AssertionInfo info) {
        return Strings.escapePercent(elementsNotSatisfyingRequirements.stream().map(unsatisfiedRequirement -> unsatisfiedRequirement.describe(info)).collect(Collectors.joining(String.format("%n%n", new Object[0]))));
    }

    public static UnsatisfiedRequirement unsatisfiedRequirement(Object elementNotSatisfyingRequirements, String errorMessage) {
        return new UnsatisfiedRequirement(elementNotSatisfyingRequirements, errorMessage);
    }

    public static class UnsatisfiedRequirement {
        private final Object elementNotSatisfyingRequirements;
        private final String errorMessage;

        public UnsatisfiedRequirement(Object elementNotSatisfyingRequirements, String errorMessage) {
            this.elementNotSatisfyingRequirements = elementNotSatisfyingRequirements;
            this.errorMessage = errorMessage;
        }

        public String describe(AssertionInfo info) {
            return String.format("  <%s> error: %s", info.representation().toStringOf(this.elementNotSatisfyingRequirements), this.errorMessage);
        }

        public String toString() {
            return String.format("  <%s> %s", this.elementNotSatisfyingRequirements, this.errorMessage);
        }
    }
}

