/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.date;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.comparator.CompareUtil;
import cn.hutool.core.date.BetweenFormatter;
import cn.hutool.core.date.CalendarUtil;
import cn.hutool.core.date.DateBetween;
import cn.hutool.core.date.DateException;
import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateRange;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.date.Month;
import cn.hutool.core.date.Quarter;
import cn.hutool.core.date.StopWatch;
import cn.hutool.core.date.TemporalAccessorUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.date.Week;
import cn.hutool.core.date.Zodiac;
import cn.hutool.core.date.format.DateParser;
import cn.hutool.core.date.format.DatePrinter;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.PatternPool;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.Year;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class DateUtil
extends CalendarUtil {
    private static final String[] wtb = new String[]{"sun", "mon", "tue", "wed", "thu", "fri", "sat", "jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec", "gmt", "ut", "utc", "est", "edt", "cst", "cdt", "mst", "mdt", "pst", "pdt"};

    public static DateTime date() {
        return new DateTime();
    }

    public static DateTime dateSecond() {
        return DateUtil.beginOfSecond(DateUtil.date());
    }

    public static DateTime date(Date date) {
        if (date instanceof DateTime) {
            return (DateTime)date;
        }
        return DateUtil.dateNew(date);
    }

    public static DateTime dateNew(Date date) {
        return new DateTime(date);
    }

    public static DateTime date(long date) {
        return new DateTime(date);
    }

    public static DateTime date(Calendar calendar) {
        return new DateTime(calendar);
    }

    public static DateTime date(TemporalAccessor temporalAccessor) {
        return new DateTime(temporalAccessor);
    }

    public static long current() {
        return System.currentTimeMillis();
    }

    public static long currentSeconds() {
        return System.currentTimeMillis() / 1000L;
    }

    public static String now() {
        return DateUtil.formatDateTime(new DateTime());
    }

    public static String today() {
        return DateUtil.formatDate(new DateTime());
    }

    public static int year(Date date) {
        return DateTime.of(date).year();
    }

    public static int quarter(Date date) {
        return DateTime.of(date).quarter();
    }

    public static Quarter quarterEnum(Date date) {
        return DateTime.of(date).quarterEnum();
    }

    public static int month(Date date) {
        return DateTime.of(date).month();
    }

    public static Month monthEnum(Date date) {
        return DateTime.of(date).monthEnum();
    }

    public static int weekOfYear(Date date) {
        return DateTime.of(date).weekOfYear();
    }

    public static int weekOfMonth(Date date) {
        return DateTime.of(date).weekOfMonth();
    }

    public static int dayOfMonth(Date date) {
        return DateTime.of(date).dayOfMonth();
    }

    public static int dayOfYear(Date date) {
        return DateTime.of(date).dayOfYear();
    }

    public static int dayOfWeek(Date date) {
        return DateTime.of(date).dayOfWeek();
    }

    public static Week dayOfWeekEnum(Date date) {
        return DateTime.of(date).dayOfWeekEnum();
    }

    public static int hour(Date date, boolean is24HourClock) {
        return DateTime.of(date).hour(is24HourClock);
    }

    public static int minute(Date date) {
        return DateTime.of(date).minute();
    }

    public static int second(Date date) {
        return DateTime.of(date).second();
    }

    @Deprecated
    public static int millsecond(Date date) {
        return DateTime.of(date).millisecond();
    }

    public static int millisecond(Date date) {
        return DateTime.of(date).millisecond();
    }

    public static boolean isAM(Date date) {
        return DateTime.of(date).isAM();
    }

    public static boolean isPM(Date date) {
        return DateTime.of(date).isPM();
    }

    public static int thisYear() {
        return DateUtil.year(DateUtil.date());
    }

    public static int thisMonth() {
        return DateUtil.month(DateUtil.date());
    }

    public static Month thisMonthEnum() {
        return DateUtil.monthEnum(DateUtil.date());
    }

    public static int thisWeekOfYear() {
        return DateUtil.weekOfYear(DateUtil.date());
    }

    public static int thisWeekOfMonth() {
        return DateUtil.weekOfMonth(DateUtil.date());
    }

    public static int thisDayOfMonth() {
        return DateUtil.dayOfMonth(DateUtil.date());
    }

    public static int thisDayOfWeek() {
        return DateUtil.dayOfWeek(DateUtil.date());
    }

    public static Week thisDayOfWeekEnum() {
        return DateUtil.dayOfWeekEnum(DateUtil.date());
    }

    public static int thisHour(boolean is24HourClock) {
        return DateUtil.hour(DateUtil.date(), is24HourClock);
    }

    public static int thisMinute() {
        return DateUtil.minute(DateUtil.date());
    }

    public static int thisSecond() {
        return DateUtil.second(DateUtil.date());
    }

    @Deprecated
    public static int thisMillsecond() {
        return DateUtil.millisecond(DateUtil.date());
    }

    public static int thisMillisecond() {
        return DateUtil.millisecond(DateUtil.date());
    }

    public static String yearAndQuarter(Date date) {
        return DateUtil.yearAndQuarter(DateUtil.calendar(date));
    }

    public static LinkedHashSet<String> yearAndQuarter(Date startDate, Date endDate) {
        if (startDate == null || endDate == null) {
            return new LinkedHashSet<String>(0);
        }
        return DateUtil.yearAndQuarter(startDate.getTime(), endDate.getTime());
    }

    public static String formatLocalDateTime(LocalDateTime localDateTime) {
        return LocalDateTimeUtil.formatNormal(localDateTime);
    }

    public static String format(LocalDateTime localDateTime, String format) {
        return LocalDateTimeUtil.format(localDateTime, format);
    }

    public static String format(Date date, String format) {
        if (null == date || StrUtil.isBlank(format)) {
            return null;
        }
        TimeZone timeZone = null;
        if (date instanceof DateTime) {
            timeZone = ((DateTime)date).getTimeZone();
        }
        return DateUtil.format(date, DateUtil.newSimpleFormat(format, null, timeZone));
    }

    public static String format(Date date, DatePrinter format) {
        if (null == format || null == date) {
            return null;
        }
        return format.format(date);
    }

    public static String format(Date date, DateFormat format) {
        if (null == format || null == date) {
            return null;
        }
        return format.format(date);
    }

    public static String format(Date date, DateTimeFormatter format) {
        if (null == format || null == date) {
            return null;
        }
        return format.format(date.toInstant());
    }

    public static String formatDateTime(Date date) {
        if (null == date) {
            return null;
        }
        return DatePattern.NORM_DATETIME_FORMAT.format(date);
    }

    public static String formatDate(Date date) {
        if (null == date) {
            return null;
        }
        return DatePattern.NORM_DATE_FORMAT.format(date);
    }

    public static String formatTime(Date date) {
        if (null == date) {
            return null;
        }
        return DatePattern.NORM_TIME_FORMAT.format(date);
    }

    public static String formatHttpDate(Date date) {
        if (null == date) {
            return null;
        }
        return DatePattern.HTTP_DATETIME_FORMAT.format(date);
    }

    public static String formatChineseDate(Date date, boolean isUppercase, boolean withTime) {
        if (null == date) {
            return null;
        }
        if (!isUppercase) {
            return (withTime ? DatePattern.CHINESE_DATE_TIME_FORMAT : DatePattern.CHINESE_DATE_FORMAT).format(date);
        }
        return CalendarUtil.formatChineseDate(CalendarUtil.calendar(date), withTime);
    }

    public static LocalDateTime parseLocalDateTime(CharSequence dateStr) {
        return DateUtil.parseLocalDateTime(dateStr, "yyyy-MM-dd HH:mm:ss");
    }

    public static LocalDateTime parseLocalDateTime(CharSequence dateStr, String format) {
        return LocalDateTimeUtil.parse(dateStr, format);
    }

    public static DateTime parse(CharSequence dateStr, DateFormat dateFormat) {
        return new DateTime(dateStr, dateFormat);
    }

    public static DateTime parse(CharSequence dateStr, DateParser parser) {
        return new DateTime(dateStr, parser);
    }

    public static DateTime parse(CharSequence dateStr, DateTimeFormatter formatter) {
        return new DateTime(dateStr, formatter);
    }

    public static DateTime parse(CharSequence dateStr, String format) {
        return new DateTime(dateStr, format);
    }

    public static DateTime parse(CharSequence dateStr, String format, Locale locale) {
        return new DateTime(dateStr, DateUtil.newSimpleFormat(format, locale, null));
    }

    public static DateTime parse(String str, String ... parsePatterns) throws DateException {
        return new DateTime(CalendarUtil.parseByPatterns(str, parsePatterns));
    }

    public static DateTime parseDateTime(CharSequence dateString) {
        dateString = DateUtil.normalize(dateString);
        return DateUtil.parse(dateString, DatePattern.NORM_DATETIME_FORMAT);
    }

    public static DateTime parseDate(CharSequence dateString) {
        dateString = DateUtil.normalize(dateString);
        return DateUtil.parse(dateString, DatePattern.NORM_DATE_FORMAT);
    }

    public static DateTime parseTime(CharSequence timeString) {
        timeString = DateUtil.normalize(timeString);
        return DateUtil.parse(timeString, DatePattern.NORM_TIME_FORMAT);
    }

    public static DateTime parseTimeToday(CharSequence timeString) {
        timeString = StrUtil.format("{} {}", DateUtil.today(), timeString);
        if (1 == StrUtil.count(timeString, ':')) {
            return DateUtil.parse(timeString, "yyyy-MM-dd HH:mm");
        }
        return DateUtil.parse(timeString, DatePattern.NORM_DATETIME_FORMAT);
    }

    public static DateTime parseUTC(String utcString) {
        if (utcString == null) {
            return null;
        }
        int length = utcString.length();
        if (StrUtil.contains((CharSequence)utcString, 'Z')) {
            if (length == "yyyy-MM-dd'T'HH:mm:ss'Z'".length() - 4) {
                return DateUtil.parse((CharSequence)utcString, DatePattern.UTC_FORMAT);
            }
            int patternLength = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'".length();
            if (length <= patternLength - 4 && length >= patternLength - 6) {
                return DateUtil.parse((CharSequence)utcString, DatePattern.UTC_MS_FORMAT);
            }
        } else {
            if (length == "yyyy-MM-dd'T'HH:mm:ssZ".length() + 2 || length == "yyyy-MM-dd'T'HH:mm:ssZ".length() + 3) {
                return DateUtil.parse((CharSequence)utcString, DatePattern.UTC_WITH_ZONE_OFFSET_FORMAT);
            }
            if (length == "yyyy-MM-dd'T'HH:mm:ss.SSSZ".length() + 2 || length == "yyyy-MM-dd'T'HH:mm:ss.SSSZ".length() + 3) {
                return DateUtil.parse((CharSequence)utcString, DatePattern.UTC_MS_WITH_ZONE_OFFSET_FORMAT);
            }
            if (length == "yyyy-MM-dd'T'HH:mm:ss".length() - 2) {
                return DateUtil.parse((CharSequence)utcString, DatePattern.UTC_SIMPLE_FORMAT);
            }
            if (StrUtil.contains((CharSequence)utcString, '.')) {
                return DateUtil.parse((CharSequence)utcString, DatePattern.UTC_SIMPLE_MS_FORMAT);
            }
        }
        throw new DateException("No format fit for date String [{}] !", utcString);
    }

    public static DateTime parseCST(CharSequence cstString) {
        if (cstString == null) {
            return null;
        }
        return DateUtil.parse(cstString, DatePattern.JDK_DATETIME_FORMAT);
    }

    public static DateTime parse(CharSequence dateCharSequence) {
        if (StrUtil.isBlank(dateCharSequence)) {
            return null;
        }
        String dateStr = dateCharSequence.toString();
        dateStr = StrUtil.removeAll((CharSequence)dateStr.trim(), '\u65e5', '\u79d2');
        int length = dateStr.length();
        if (NumberUtil.isNumber(dateStr)) {
            if (length == "yyyyMMddHHmmss".length()) {
                return DateUtil.parse((CharSequence)dateStr, DatePattern.PURE_DATETIME_FORMAT);
            }
            if (length == "yyyyMMddHHmmssSSS".length()) {
                return DateUtil.parse((CharSequence)dateStr, DatePattern.PURE_DATETIME_MS_FORMAT);
            }
            if (length == "yyyyMMdd".length()) {
                return DateUtil.parse((CharSequence)dateStr, DatePattern.PURE_DATE_FORMAT);
            }
            if (length == "HHmmss".length()) {
                return DateUtil.parse((CharSequence)dateStr, DatePattern.PURE_TIME_FORMAT);
            }
        } else {
            if (ReUtil.isMatch(PatternPool.TIME, (CharSequence)dateStr)) {
                return DateUtil.parseTimeToday(dateStr);
            }
            if (StrUtil.containsAnyIgnoreCase(dateStr, wtb)) {
                return DateUtil.parseCST(dateStr);
            }
            if (StrUtil.contains((CharSequence)dateStr, 'T')) {
                return DateUtil.parseUTC(dateStr);
            }
        }
        if (ReUtil.isMatch(DatePattern.REGEX_NORM, (CharSequence)(dateStr = DateUtil.normalize(dateStr)))) {
            int colonCount = StrUtil.count((CharSequence)dateStr, ':');
            switch (colonCount) {
                case 0: {
                    return DateUtil.parse((CharSequence)dateStr, DatePattern.NORM_DATE_FORMAT);
                }
                case 1: {
                    return DateUtil.parse((CharSequence)dateStr, DatePattern.NORM_DATETIME_MINUTE_FORMAT);
                }
                case 2: {
                    if (StrUtil.contains((CharSequence)dateStr, '.')) {
                        return DateUtil.parse((CharSequence)dateStr, DatePattern.NORM_DATETIME_MS_FORMAT);
                    }
                    return DateUtil.parse((CharSequence)dateStr, DatePattern.NORM_DATETIME_FORMAT);
                }
            }
        }
        throw new DateException("No format fit for date String [{}] !", dateStr);
    }

    public static DateTime truncate(Date date, DateField dateField) {
        return new DateTime(DateUtil.truncate(DateUtil.calendar(date), dateField));
    }

    public static DateTime round(Date date, DateField dateField) {
        return new DateTime(DateUtil.round(DateUtil.calendar(date), dateField));
    }

    public static DateTime ceiling(Date date, DateField dateField) {
        return new DateTime(DateUtil.ceiling(DateUtil.calendar(date), dateField));
    }

    public static DateTime beginOfSecond(Date date) {
        return new DateTime(DateUtil.beginOfSecond(DateUtil.calendar(date)));
    }

    public static DateTime endOfSecond(Date date) {
        return new DateTime(DateUtil.endOfSecond(DateUtil.calendar(date)));
    }

    public static DateTime beginOfHour(Date date) {
        return new DateTime(DateUtil.beginOfHour(DateUtil.calendar(date)));
    }

    public static DateTime endOfHour(Date date) {
        return new DateTime(DateUtil.endOfHour(DateUtil.calendar(date)));
    }

    public static DateTime beginOfMinute(Date date) {
        return new DateTime(DateUtil.beginOfMinute(DateUtil.calendar(date)));
    }

    public static DateTime endOfMinute(Date date) {
        return new DateTime(DateUtil.endOfMinute(DateUtil.calendar(date)));
    }

    public static DateTime beginOfDay(Date date) {
        return new DateTime(DateUtil.beginOfDay(DateUtil.calendar(date)));
    }

    public static DateTime endOfDay(Date date) {
        return new DateTime(DateUtil.endOfDay(DateUtil.calendar(date)));
    }

    public static DateTime beginOfWeek(Date date) {
        return new DateTime(DateUtil.beginOfWeek(DateUtil.calendar(date)));
    }

    public static DateTime beginOfWeek(Date date, boolean isMondayAsFirstDay) {
        return new DateTime(DateUtil.beginOfWeek(DateUtil.calendar(date), isMondayAsFirstDay));
    }

    public static DateTime endOfWeek(Date date) {
        return new DateTime(DateUtil.endOfWeek(DateUtil.calendar(date)));
    }

    public static DateTime endOfWeek(Date date, boolean isSundayAsLastDay) {
        return new DateTime(DateUtil.endOfWeek(DateUtil.calendar(date), isSundayAsLastDay));
    }

    public static DateTime beginOfMonth(Date date) {
        return new DateTime(DateUtil.beginOfMonth(DateUtil.calendar(date)));
    }

    public static DateTime endOfMonth(Date date) {
        return new DateTime(DateUtil.endOfMonth(DateUtil.calendar(date)));
    }

    public static DateTime beginOfQuarter(Date date) {
        return new DateTime(DateUtil.beginOfQuarter(DateUtil.calendar(date)));
    }

    public static DateTime endOfQuarter(Date date) {
        return new DateTime(DateUtil.endOfQuarter(DateUtil.calendar(date)));
    }

    public static DateTime beginOfYear(Date date) {
        return new DateTime(DateUtil.beginOfYear(DateUtil.calendar(date)));
    }

    public static DateTime endOfYear(Date date) {
        return new DateTime(DateUtil.endOfYear(DateUtil.calendar(date)));
    }

    public static DateTime yesterday() {
        return DateUtil.offsetDay(new DateTime(), -1);
    }

    public static DateTime tomorrow() {
        return DateUtil.offsetDay(new DateTime(), 1);
    }

    public static DateTime lastWeek() {
        return DateUtil.offsetWeek(new DateTime(), -1);
    }

    public static DateTime nextWeek() {
        return DateUtil.offsetWeek(new DateTime(), 1);
    }

    public static DateTime lastMonth() {
        return DateUtil.offsetMonth(new DateTime(), -1);
    }

    public static DateTime nextMonth() {
        return DateUtil.offsetMonth(new DateTime(), 1);
    }

    public static DateTime offsetMillisecond(Date date, int offset) {
        return DateUtil.offset(date, DateField.MILLISECOND, offset);
    }

    public static DateTime offsetSecond(Date date, int offset) {
        return DateUtil.offset(date, DateField.SECOND, offset);
    }

    public static DateTime offsetMinute(Date date, int offset) {
        return DateUtil.offset(date, DateField.MINUTE, offset);
    }

    public static DateTime offsetHour(Date date, int offset) {
        return DateUtil.offset(date, DateField.HOUR_OF_DAY, offset);
    }

    public static DateTime offsetDay(Date date, int offset) {
        return DateUtil.offset(date, DateField.DAY_OF_YEAR, offset);
    }

    public static DateTime offsetWeek(Date date, int offset) {
        return DateUtil.offset(date, DateField.WEEK_OF_YEAR, offset);
    }

    public static DateTime offsetMonth(Date date, int offset) {
        return DateUtil.offset(date, DateField.MONTH, offset);
    }

    public static DateTime offset(Date date, DateField dateField, int offset) {
        return DateUtil.dateNew(date).offset(dateField, offset);
    }

    @Deprecated
    public static DateTime offsetDate(Date date, DateField dateField, int offset) {
        return DateUtil.offset(date, dateField, offset);
    }

    public static long between(Date beginDate, Date endDate, DateUnit unit) {
        return DateUtil.between(beginDate, endDate, unit, true);
    }

    public static long between(Date beginDate, Date endDate, DateUnit unit, boolean isAbs) {
        return new DateBetween(beginDate, endDate, isAbs).between(unit);
    }

    public static long betweenMs(Date beginDate, Date endDate) {
        return new DateBetween(beginDate, endDate).between(DateUnit.MS);
    }

    public static long betweenDay(Date beginDate, Date endDate, boolean isReset) {
        if (isReset) {
            beginDate = DateUtil.beginOfDay(beginDate);
            endDate = DateUtil.beginOfDay(endDate);
        }
        return DateUtil.between(beginDate, endDate, DateUnit.DAY);
    }

    public static long betweenWeek(Date beginDate, Date endDate, boolean isReset) {
        if (isReset) {
            beginDate = DateUtil.beginOfDay(beginDate);
            endDate = DateUtil.beginOfDay(endDate);
        }
        return DateUtil.between(beginDate, endDate, DateUnit.WEEK);
    }

    public static long betweenMonth(Date beginDate, Date endDate, boolean isReset) {
        return new DateBetween(beginDate, endDate).betweenMonth(isReset);
    }

    public static long betweenYear(Date beginDate, Date endDate, boolean isReset) {
        return new DateBetween(beginDate, endDate).betweenYear(isReset);
    }

    public static String formatBetween(Date beginDate, Date endDate, BetweenFormatter.Level level) {
        return DateUtil.formatBetween(DateUtil.between(beginDate, endDate, DateUnit.MS), level);
    }

    public static String formatBetween(Date beginDate, Date endDate) {
        return DateUtil.formatBetween(DateUtil.between(beginDate, endDate, DateUnit.MS));
    }

    public static String formatBetween(long betweenMs, BetweenFormatter.Level level) {
        return new BetweenFormatter(betweenMs, level).format();
    }

    public static String formatBetween(long betweenMs) {
        return new BetweenFormatter(betweenMs, BetweenFormatter.Level.MILLISECOND).format();
    }

    public static boolean isIn(Date date, Date beginDate, Date endDate) {
        if (date instanceof DateTime) {
            return ((DateTime)date).isIn(beginDate, endDate);
        }
        return new DateTime(date).isIn(beginDate, endDate);
    }

    public static boolean isSameTime(Date date1, Date date2) {
        return date1.compareTo(date2) == 0;
    }

    public static boolean isSameDay(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return CalendarUtil.isSameDay(DateUtil.calendar(date1), DateUtil.calendar(date2));
    }

    public static boolean isSameMonth(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return CalendarUtil.isSameMonth(DateUtil.calendar(date1), DateUtil.calendar(date2));
    }

    public static long spendNt(long preTime) {
        return System.nanoTime() - preTime;
    }

    public static long spendMs(long preTime) {
        return System.currentTimeMillis() - preTime;
    }

    public static int toIntSecond(Date date) {
        return Integer.parseInt(DateUtil.format(date, "yyMMddHHmm"));
    }

    @Deprecated
    public static int weekCount(Date start, Date end) {
        return (int)DateUtil.betweenWeek(start, end, true);
    }

    public static TimeInterval timer() {
        return new TimeInterval();
    }

    public static TimeInterval timer(boolean isNano) {
        return new TimeInterval(isNano);
    }

    public static StopWatch createStopWatch() {
        return new StopWatch();
    }

    public static StopWatch createStopWatch(String id) {
        return new StopWatch(id);
    }

    public static int ageOfNow(String birthDay) {
        return DateUtil.ageOfNow(DateUtil.parse(birthDay));
    }

    public static int ageOfNow(Date birthDay) {
        return DateUtil.age(birthDay, DateUtil.date());
    }

    public static boolean isLeapYear(int year) {
        return new GregorianCalendar().isLeapYear(year);
    }

    public static int age(Date birthday, Date dateToCompare) {
        Assert.notNull(birthday, "Birthday can not be null !", new Object[0]);
        if (null == dateToCompare) {
            dateToCompare = DateUtil.date();
        }
        return DateUtil.age(birthday.getTime(), dateToCompare.getTime());
    }

    @Deprecated
    public static boolean isExpired(Date startDate, DateField dateField, int timeLength, Date endDate) {
        DateTime offsetDate = DateUtil.offset(startDate, dateField, timeLength);
        return offsetDate.after(endDate);
    }

    @Deprecated
    public static boolean isExpired(Date startDate, Date endDate, Date checkDate) {
        return DateUtil.betweenMs(startDate, checkDate) > DateUtil.betweenMs(startDate, endDate);
    }

    public static int timeToSecond(String timeStr) {
        if (StrUtil.isEmpty(timeStr)) {
            return 0;
        }
        List<String> hms = StrUtil.splitTrim((CharSequence)timeStr, ':', 3);
        int lastIndex = hms.size() - 1;
        int result = 0;
        for (int i = lastIndex; i >= 0; --i) {
            result = (int)((double)result + (double)Integer.parseInt(hms.get(i)) * Math.pow(60.0, lastIndex - i));
        }
        return result;
    }

    public static String secondToTime(int seconds) {
        if (seconds < 0) {
            throw new IllegalArgumentException("Seconds must be a positive number!");
        }
        int hour = seconds / 3600;
        int other = seconds % 3600;
        int minute = other / 60;
        int second = other % 60;
        StringBuilder sb = new StringBuilder();
        if (hour < 10) {
            sb.append("0");
        }
        sb.append(hour);
        sb.append(":");
        if (minute < 10) {
            sb.append("0");
        }
        sb.append(minute);
        sb.append(":");
        if (second < 10) {
            sb.append("0");
        }
        sb.append(second);
        return sb.toString();
    }

    public static DateRange range(Date start, Date end, DateField unit) {
        return new DateRange(start, end, unit);
    }

    public static List<DateTime> rangeToList(Date start, Date end, DateField unit) {
        return CollUtil.newArrayList(DateUtil.range(start, end, unit));
    }

    public static String getZodiac(int month, int day) {
        return Zodiac.getZodiac(month, day);
    }

    public static String getChineseZodiac(int year) {
        return Zodiac.getChineseZodiac(year);
    }

    public static int compare(Date date1, Date date2) {
        return CompareUtil.compare(date1, date2);
    }

    public static int compare(Date date1, Date date2, String format) {
        if (format != null) {
            if (date1 != null) {
                date1 = DateUtil.parse((CharSequence)DateUtil.format(date1, format), format);
            }
            if (date2 != null) {
                date2 = DateUtil.parse((CharSequence)DateUtil.format(date2, format), format);
            }
        }
        return CompareUtil.compare(date1, date2);
    }

    public static long nanosToMillis(long duration) {
        return TimeUnit.NANOSECONDS.toMillis(duration);
    }

    public static double nanosToSeconds(long duration) {
        return (double)duration / 1.0E9;
    }

    public static Instant toInstant(Date date) {
        return null == date ? null : date.toInstant();
    }

    public static Instant toInstant(TemporalAccessor temporalAccessor) {
        return TemporalAccessorUtil.toInstant(temporalAccessor);
    }

    public static LocalDateTime toLocalDateTime(Instant instant) {
        return LocalDateTimeUtil.of(instant);
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        return LocalDateTimeUtil.of(date);
    }

    public static int lengthOfYear(int year) {
        return Year.of(year).length();
    }

    public static int lengthOfMonth(int month, boolean isLeapYear) {
        return java.time.Month.of(month).length(isLeapYear);
    }

    public static SimpleDateFormat newSimpleFormat(String pattern) {
        return DateUtil.newSimpleFormat(pattern, null, null);
    }

    public static SimpleDateFormat newSimpleFormat(String pattern, Locale locale, TimeZone timeZone) {
        if (null == locale) {
            locale = Locale.getDefault(Locale.Category.FORMAT);
        }
        SimpleDateFormat format = new SimpleDateFormat(pattern, locale);
        if (null != timeZone) {
            format.setTimeZone(timeZone);
        }
        format.setLenient(false);
        return format;
    }

    private static String normalize(CharSequence dateStr) {
        if (StrUtil.isBlank(dateStr)) {
            return StrUtil.str(dateStr);
        }
        List<String> dateAndTime = StrUtil.splitTrim(dateStr, ' ');
        int size = dateAndTime.size();
        if (size < 1 || size > 2) {
            return StrUtil.str(dateStr);
        }
        StringBuilder builder = StrUtil.builder();
        String datePart = dateAndTime.get(0).replaceAll("[/.\u5e74\u6708]", "-");
        datePart = StrUtil.removeSuffix(datePart, "\u65e5");
        builder.append(datePart);
        if (size == 2) {
            builder.append(' ');
            String timePart = dateAndTime.get(1).replaceAll("[\u65f6\u5206\u79d2]", ":");
            timePart = StrUtil.removeSuffix(timePart, ":");
            timePart = timePart.replace(',', '.');
            builder.append(timePart);
        }
        return builder.toString();
    }
}

