/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.handlers;

import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.extension.handlers.AbstractJsonTypeHandler;
import com.google.gson.Gson;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MappedTypes(value={Object.class})
@MappedJdbcTypes(value={JdbcType.VARCHAR})
public class GsonTypeHandler
extends AbstractJsonTypeHandler<Object> {
    private static final Logger log = LoggerFactory.getLogger(GsonTypeHandler.class);
    private static Gson gson = new Gson();
    private final Class<?> type;

    public GsonTypeHandler(Class<?> type) {
        if (log.isTraceEnabled()) {
            log.trace("GsonTypeHandler(" + type + ")");
        }
        Assert.notNull(type, (String)"Type argument cannot be null", (Object[])new Object[0]);
        this.type = type;
    }

    @Override
    protected Object parse(String json) {
        return gson.fromJson(json, this.type);
    }

    @Override
    protected String toJson(Object obj) {
        return gson.toJson(obj);
    }

    public static void setGson(Gson gson) {
        Assert.notNull((Object)gson, (String)"Gson should not be null", (Object[])new Object[0]);
        GsonTypeHandler.gson = gson;
    }
}

