/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mobile.autoconfigure;

import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Configuration;
import org.springframework.mobile.autoconfigure.DeviceResolverAutoConfiguration;
import org.springframework.mobile.device.site.SitePreferenceHandler;
import org.springframework.mobile.device.site.SitePreferenceHandlerInterceptor;
import org.springframework.mobile.device.site.SitePreferenceHandlerMethodArgumentResolver;
import org.springframework.mobile.device.site.annotation.EnableSitePreference;
import org.springframework.mobile.device.site.annotation.SitePreferenceConfigurer;

@Configuration
@ConditionalOnClass(value={SitePreferenceHandlerInterceptor.class, SitePreferenceHandlerMethodArgumentResolver.class})
@AutoConfigureAfter(value={DeviceResolverAutoConfiguration.class})
@ConditionalOnProperty(prefix="spring.mobile.sitepreference", name={"enabled"}, havingValue="true", matchIfMissing=true)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class SitePreferenceAutoConfiguration {

    @Configuration
    @ConditionalOnMissingBean(value={SitePreferenceHandler.class})
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    @EnableSitePreference
    public static class DefaultSitePreferenceConfigurationAdapter {
    }

    @Configuration
    @ConditionalOnBean(value={SitePreferenceHandler.class})
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    @EnableSitePreference
    protected static class SitePreferenceConfigurationAdapter
    implements SitePreferenceConfigurer {
        private SitePreferenceHandler sitePreferenceHandler;

        public SitePreferenceConfigurationAdapter(SitePreferenceHandler sitePreferenceHandler) {
            this.sitePreferenceHandler = sitePreferenceHandler;
        }

        public SitePreferenceHandler getSitePreferenceHandler() {
            return this.sitePreferenceHandler;
        }
    }
}

