/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mobile.device;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.mobile.device.Device;
import org.springframework.mobile.device.DeviceResolver;
import org.springframework.mobile.device.LiteDeviceResolver;
import org.springframework.web.filter.OncePerRequestFilter;

public class DeviceResolverRequestFilter
extends OncePerRequestFilter {
    private final DeviceResolver deviceResolver;

    public DeviceResolverRequestFilter() {
        this(new LiteDeviceResolver());
    }

    public DeviceResolverRequestFilter(DeviceResolver deviceResolver) {
        this.deviceResolver = deviceResolver;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        Device device = this.deviceResolver.resolveDevice(request);
        request.setAttribute("currentDevice", (Object)device);
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

