/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.metadata.data;

import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.AbstractCell;
import com.alibaba.excel.metadata.data.FormulaData;
import com.alibaba.excel.util.StringUtils;
import java.math.BigDecimal;

public class CellData<T>
extends AbstractCell {
    private CellDataTypeEnum type;
    private BigDecimal numberValue;
    private String stringValue;
    private Boolean booleanValue;
    private T data;
    private FormulaData formulaData;

    public void checkEmpty() {
        if (this.type == null) {
            this.type = CellDataTypeEnum.EMPTY;
        }
        switch (this.type) {
            case STRING: 
            case ERROR: {
                if (StringUtils.isEmpty(this.stringValue)) {
                    this.type = CellDataTypeEnum.EMPTY;
                }
                return;
            }
            case NUMBER: {
                if (this.numberValue == null) {
                    this.type = CellDataTypeEnum.EMPTY;
                }
                return;
            }
            case BOOLEAN: {
                if (this.booleanValue == null) {
                    this.type = CellDataTypeEnum.EMPTY;
                }
                return;
            }
        }
    }

    public CellDataTypeEnum getType() {
        return this.type;
    }

    public BigDecimal getNumberValue() {
        return this.numberValue;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public Boolean getBooleanValue() {
        return this.booleanValue;
    }

    public T getData() {
        return this.data;
    }

    public FormulaData getFormulaData() {
        return this.formulaData;
    }

    public void setType(CellDataTypeEnum type) {
        this.type = type;
    }

    public void setNumberValue(BigDecimal numberValue) {
        this.numberValue = numberValue;
    }

    public void setStringValue(String stringValue) {
        this.stringValue = stringValue;
    }

    public void setBooleanValue(Boolean booleanValue) {
        this.booleanValue = booleanValue;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setFormulaData(FormulaData formulaData) {
        this.formulaData = formulaData;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CellData)) {
            return false;
        }
        CellData other = (CellData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$booleanValue = this.getBooleanValue();
        Boolean other$booleanValue = other.getBooleanValue();
        if (this$booleanValue == null ? other$booleanValue != null : !((Object)this$booleanValue).equals(other$booleanValue)) {
            return false;
        }
        CellDataTypeEnum this$type = this.getType();
        CellDataTypeEnum other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        BigDecimal this$numberValue = this.getNumberValue();
        BigDecimal other$numberValue = other.getNumberValue();
        if (this$numberValue == null ? other$numberValue != null : !((Object)this$numberValue).equals(other$numberValue)) {
            return false;
        }
        String this$stringValue = this.getStringValue();
        String other$stringValue = other.getStringValue();
        if (this$stringValue == null ? other$stringValue != null : !this$stringValue.equals(other$stringValue)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        FormulaData this$formulaData = this.getFormulaData();
        FormulaData other$formulaData = other.getFormulaData();
        return !(this$formulaData == null ? other$formulaData != null : !((Object)this$formulaData).equals(other$formulaData));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CellData;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $booleanValue = this.getBooleanValue();
        result = result * 59 + ($booleanValue == null ? 43 : ((Object)$booleanValue).hashCode());
        CellDataTypeEnum $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        BigDecimal $numberValue = this.getNumberValue();
        result = result * 59 + ($numberValue == null ? 43 : ((Object)$numberValue).hashCode());
        String $stringValue = this.getStringValue();
        result = result * 59 + ($stringValue == null ? 43 : $stringValue.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        FormulaData $formulaData = this.getFormulaData();
        result = result * 59 + ($formulaData == null ? 43 : ((Object)$formulaData).hashCode());
        return result;
    }
}

