layui.define(["layer", "jquery"], function (exports) {

    var iframeEdit = {
        populateIframe: function (iframe, url, headers) {
            var xhr = new XMLHttpRequest();
            xhr.open('GET', url);
            xhr.onreadystatechange = handler;
            xhr.responseType = 'blob';
            headers.forEach(function (header) {
                xhr.setRequestHeader(header[0], header[1]);
            });
            xhr.send();

            function handler() {
                if (this.readyState === this.DONE) {
                    if (this.status === 200) {
                        // this.response is a Blob, because we set responseType above
                        iframe.src = URL.createObjectURL(this.response);
                    } else {
                        console.error('XHR failed', this);
                    }
                }
            }


        },

        setPDF: function (blob) {
            document.querySelector('#blob').src = URL.createObjectURL(blob);
        }
    };
    exports('iframeEdit', iframeEdit);
})