/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mobile.autoconfigure;

import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.context.annotation.Configuration;
import org.springframework.mobile.device.DeviceHandlerMethodArgumentResolver;
import org.springframework.mobile.device.DeviceResolver;
import org.springframework.mobile.device.DeviceResolverHandlerInterceptor;
import org.springframework.mobile.device.annotation.DeviceResolverConfigurer;
import org.springframework.mobile.device.annotation.EnableDeviceResolver;

@Configuration
@ConditionalOnClass(value={DeviceResolverHandlerInterceptor.class, DeviceHandlerMethodArgumentResolver.class})
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class DeviceResolverAutoConfiguration {

    @Configuration
    @ConditionalOnMissingBean(value={DeviceResolver.class})
    @EnableDeviceResolver
    protected static class DefaultDeviceResolverConfigurationAdapter {
        protected DefaultDeviceResolverConfigurationAdapter() {
        }
    }

    @Configuration
    @ConditionalOnBean(value={DeviceResolver.class})
    @EnableDeviceResolver
    protected static class DeviceResolverConfigurationAdapter
    implements DeviceResolverConfigurer {
        private DeviceResolver deviceResolver;

        public DeviceResolverConfigurationAdapter(DeviceResolver deviceResolver) {
            this.deviceResolver = deviceResolver;
        }

        public DeviceResolver getDeviceResolver() {
            return this.deviceResolver;
        }
    }
}

