/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.result;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.springframework.test.util.AssertionErrors;
import org.springframework.test.web.servlet.ResultMatcher;

public class FlashAttributeResultMatchers {
    protected FlashAttributeResultMatchers() {
    }

    public <T> ResultMatcher attribute(String name, Matcher<T> matcher) {
        return result -> MatcherAssert.assertThat((String)("Flash attribute '" + name + "'"), (Object)result.getFlashMap().get((Object)name), (Matcher)matcher);
    }

    public ResultMatcher attribute(String name, Object value) {
        return result -> AssertionErrors.assertEquals("Flash attribute '" + name + "'", value, result.getFlashMap().get((Object)name));
    }

    public ResultMatcher attributeExists(String ... names) {
        return result -> {
            for (String name : names) {
                AssertionErrors.assertNotNull("Flash attribute '" + name + "' does not exist", result.getFlashMap().get((Object)name));
            }
        };
    }

    public ResultMatcher attributeCount(int count) {
        return result -> AssertionErrors.assertEquals("FlashMap size", count, result.getFlashMap().size());
    }
}

