/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang.tree;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.tree.Tree;
import cn.hutool.core.lang.tree.TreeNode;
import cn.hutool.core.lang.tree.TreeNodeConfig;
import cn.hutool.core.lang.tree.parser.DefaultNodeParser;
import cn.hutool.core.lang.tree.parser.NodeParser;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TreeUtil {
    public static List<Tree<Integer>> build(List<TreeNode<Integer>> list) {
        return TreeUtil.build(list, Integer.valueOf(0));
    }

    public static <E> List<Tree<E>> build(List<TreeNode<E>> list, E parentId) {
        return TreeUtil.build(list, parentId, TreeNodeConfig.DEFAULT_CONFIG, new DefaultNodeParser());
    }

    public static <T, E> List<Tree<E>> build(List<T> list, E parentId, NodeParser<T, E> nodeParser) {
        return TreeUtil.build(list, parentId, TreeNodeConfig.DEFAULT_CONFIG, nodeParser);
    }

    public static <T, E> List<Tree<E>> build(List<T> list, E rootId, TreeNodeConfig treeNodeConfig, NodeParser<T, E> nodeParser) {
        LinkedHashMap map = new LinkedHashMap(list.size(), 1.0f);
        for (T t : list) {
            Tree node = new Tree(treeNodeConfig);
            nodeParser.parse(t, node);
            map.put(node.getId(), node);
        }
        return TreeUtil.build(map, rootId);
    }

    public static <E> List<Tree<E>> build(Map<E, Tree<E>> map, E rootId) {
        Map<E, Tree<E>> eTreeMap = MapUtil.sortByValue(map, false);
        ArrayList<Tree<Tree<E>>> rootTreeList = CollUtil.newArrayList(new Tree[0]);
        for (Tree<E> node : eTreeMap.values()) {
            E parentId = node.getParentId();
            if (ObjectUtil.equals(rootId, parentId)) {
                rootTreeList.add(node);
                continue;
            }
            Tree<E> parentNode = map.get(parentId);
            if (null == parentNode) continue;
            parentNode.addChildren(node);
        }
        return rootTreeList;
    }

    public static <T> Tree<T> getNode(Tree<T> node, T id) {
        if (ObjectUtil.equal(id, node.getId())) {
            return node;
        }
        List<Tree<T>> children = node.getChildren();
        if (null == children) {
            return null;
        }
        for (Tree<T> child : children) {
            Tree<T> childNode = child.getNode(id);
            if (null == childNode) continue;
            return childNode;
        }
        return null;
    }

    public static <T> List<CharSequence> getParentsName(Tree<T> node, boolean includeCurrentNode) {
        ArrayList<CharSequence> result = new ArrayList<CharSequence>();
        if (null == node) {
            return result;
        }
        if (includeCurrentNode) {
            result.add(node.getName());
        }
        for (Tree<T> parent = node.getParent(); null != parent; parent = parent.getParent()) {
            result.add(parent.getName());
        }
        return result;
    }
}

