/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.neo4j;

import java.util.Collections;
import java.util.Map;
import org.neo4j.ogm.model.Result;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;

public class Neo4jHealthIndicator
extends AbstractHealthIndicator {
    static final String CYPHER = "CALL dbms.components() YIELD versions, edition UNWIND versions as version return version, edition";
    private final SessionFactory sessionFactory;

    public Neo4jHealthIndicator(SessionFactory sessionFactory) {
        super("Neo4J health check failed");
        this.sessionFactory = sessionFactory;
    }

    @Override
    protected void doHealthCheck(Health.Builder builder) throws Exception {
        Session session = this.sessionFactory.openSession();
        this.extractResult(session, builder);
    }

    protected void extractResult(Session session, Health.Builder builder) throws Exception {
        Result result = session.query(CYPHER, Collections.emptyMap());
        builder.up().withDetails((Map)((Iterable)result.queryResults()).iterator().next());
    }
}

