/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.redis;

import java.util.Properties;
import org.springframework.boot.actuate.health.AbstractReactiveHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.data.redis.connection.ReactiveRedisClusterConnection;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.ReactiveRedisConnectionFactory;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class RedisReactiveHealthIndicator
extends AbstractReactiveHealthIndicator {
    private static final String REDIS_VERSION_PROPERTY = "redis_version";
    private final ReactiveRedisConnectionFactory connectionFactory;

    public RedisReactiveHealthIndicator(ReactiveRedisConnectionFactory connectionFactory) {
        super("Redis health check failed");
        this.connectionFactory = connectionFactory;
    }

    @Override
    protected Mono<Health> doHealthCheck(Health.Builder builder) {
        return this.getConnection().flatMap(connection -> this.doHealthCheck(builder, (ReactiveRedisConnection)connection));
    }

    private Mono<Health> doHealthCheck(Health.Builder builder, ReactiveRedisConnection connection) {
        boolean isClusterConnection = connection instanceof ReactiveRedisClusterConnection;
        return connection.serverCommands().info("server").map(info -> this.up(builder, (Properties)info, isClusterConnection)).onErrorResume(ex -> Mono.just((Object)this.down(builder, (Throwable)ex))).flatMap(health -> connection.closeLater().thenReturn(health));
    }

    private Mono<ReactiveRedisConnection> getConnection() {
        return Mono.fromSupplier(() -> ((ReactiveRedisConnectionFactory)this.connectionFactory).getReactiveConnection()).subscribeOn(Schedulers.boundedElastic());
    }

    private Health up(Health.Builder builder, Properties info, boolean isClusterConnection) {
        String version = isClusterConnection ? this.getClusterVersionProperty(info) : info.getProperty(REDIS_VERSION_PROPERTY);
        return builder.up().withDetail("version", version).build();
    }

    private Health down(Health.Builder builder, Throwable cause) {
        return builder.down(cause).build();
    }

    private String getClusterVersionProperty(Properties info) {
        for (String propertyName : info.stringPropertyNames()) {
            if (!propertyName.endsWith(REDIS_VERSION_PROPERTY)) continue;
            return info.getProperty(propertyName);
        }
        return "";
    }
}

