layui.define(["layer", "jquery"], function (exports) {
    var $ = layui.$,
        layer = layui.layer;


    var sendRequest = {

        sendGetForNoLayer: function (url, reqData, rollback) {
            $.ajax({
                url: url,
                type: "GET",
                data: reqData,
                contentType: "application/json;charset=utf-8",
                beforeSend: function (xhr) {
                    xhr.setRequestHeader("user-key", window.localStorage.getItem("key"));
                    xhr.setRequestHeader("user-token", window.localStorage.getItem("token"));
                },
                success: function (d) {
                    rollback(d);
                },
                error: function (e) {
                    console.log(e)
                }
            })
        },


        sendGetForLayer: function (url, reqData, rollback) {
            $.ajax({
                url: url,
                type: "GET",
                dataType: 'json',
                data: reqData,
                contentType: "application/json;charset=utf-8",
                beforeSend: function (xhr) {
                    xhr.setRequestHeader("user-key", window.localStorage.getItem("key"));
                    xhr.setRequestHeader("user-token", window.localStorage.getItem("token"));
                    this.layerIndex = layer.load(0, {shade: [0.5, '#393D49']});
                },
                success: function (d) {
                    rollback(d);
                }
            })
        },


        sendPostForNoLayer: function (url, reqData, rollback) {
            $.ajax({
                url: url,
                type: "POST",
                dataType: 'json',
                data: JSON.stringify(reqData),
                contentType: "application/json;charset=utf-8",
                beforeSend: function (xhr) {
                    xhr.setRequestHeader("user-key", window.localStorage.getItem("key"));
                    xhr.setRequestHeader("user-token", window.localStorage.getItem("token"));
                },
                success: function (d) {
                    rollback(d);
                }
            })
        },


        sendPostForLayer: function (url, reqData, rollback) {
            $.ajax({
                url: url,
                type: "POST",
                dataType: 'json',
                data: JSON.stringify(reqData),
                contentType: "application/json;charset=utf-8",
                beforeSend: function () {
                    xhr.setRequestHeader("user-key", window.localStorage.getItem("key"));
                    xhr.setRequestHeader("user-token", window.localStorage.getItem("token"));
                    this.layerIndex = layer.load(0, {shade: [0.5, '#393D49']});
                },
                success: function (d) {
                    rollback(d);
                }
            })
        },

    };




    exports('sendRequest', sendRequest);
});

