/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.expression;

import java.sql.Timestamp;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.parser.ASTNodeAccessImpl;

public class TimestampValue
extends ASTNodeAccessImpl
implements Expression {
    private Timestamp value;
    private String rawValue;
    private static final char QUOTATION = '\'';

    public TimestampValue() {
    }

    public TimestampValue(String value) {
        if (value == null) {
            throw new IllegalArgumentException("null string");
        }
        this.setRawValue(value);
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public Timestamp getValue() {
        return this.value;
    }

    public void setValue(Timestamp d) {
        this.value = d;
    }

    public String getRawValue() {
        return this.rawValue;
    }

    public void setRawValue(String rawValue) {
        this.rawValue = rawValue;
        this.value = rawValue.charAt(0) == '\'' ? Timestamp.valueOf(rawValue.substring(1, rawValue.length() - 1)) : Timestamp.valueOf(rawValue.substring(0, rawValue.length()));
    }

    public String toString() {
        return "{ts '" + this.value + "'}";
    }

    public TimestampValue withValue(Timestamp value) {
        this.setValue(value);
        return this;
    }
}

