/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.write.style;

import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.write.handler.CellWriteHandler;
import com.alibaba.excel.write.handler.context.CellWriteHandlerContext;
import org.apache.poi.ss.usermodel.Cell;

public abstract class AbstractCellStyleStrategy
implements CellWriteHandler {
    @Override
    public int order() {
        return -50000;
    }

    @Override
    public void afterCellDispose(CellWriteHandlerContext context) {
        if (context.getHead() == null) {
            return;
        }
        if (context.getHead().booleanValue()) {
            this.setHeadCellStyle(context);
        } else {
            this.setContentCellStyle(context);
        }
    }

    protected void setHeadCellStyle(CellWriteHandlerContext context) {
        this.setHeadCellStyle(context.getCell(), context.getHeadData(), context.getRelativeRowIndex());
    }

    protected void setHeadCellStyle(Cell cell, Head head, Integer relativeRowIndex) {
        throw new UnsupportedOperationException("Custom styles must override the setHeadCellStyle method.");
    }

    protected void setContentCellStyle(CellWriteHandlerContext context) {
        this.setContentCellStyle(context.getCell(), context.getHeadData(), context.getRelativeRowIndex());
    }

    protected void setContentCellStyle(Cell cell, Head head, Integer relativeRowIndex) {
        throw new UnsupportedOperationException("Custom styles must override the setContentCellStyle method.");
    }
}

