/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.plugins;

import com.baomidou.mybatisplus.core.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.core.parser.SqlParserHelper;
import com.baomidou.mybatisplus.core.toolkit.EncryptUtils;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.update.Update;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;

@Deprecated
@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class IllegalSQLInterceptor
implements Interceptor {
    private static final Set<String> cacheValidResult = new HashSet<String>();
    private static final Log logger = LogFactory.getLog(IllegalSQLInterceptor.class);
    private static final Map<String, List<IndexInfo>> indexInfoMap = new ConcurrentHashMap<String, List<IndexInfo>>();

    private static void validExpression(Expression expression) {
        InExpression inExpression;
        if (expression instanceof OrExpression) {
            OrExpression orExpression = (OrExpression)expression;
            throw new MybatisPlusException("\u975e\u6cd5SQL\uff0cwhere\u6761\u4ef6\u4e2d\u4e0d\u80fd\u4f7f\u7528\u3010or\u3011\u5173\u952e\u5b57\uff0c\u9519\u8befor\u4fe1\u606f\uff1a" + orExpression.toString());
        }
        if (expression instanceof NotEqualsTo) {
            NotEqualsTo notEqualsTo = (NotEqualsTo)expression;
            throw new MybatisPlusException("\u975e\u6cd5SQL\uff0cwhere\u6761\u4ef6\u4e2d\u4e0d\u80fd\u4f7f\u7528\u3010!=\u3011\u5173\u952e\u5b57\uff0c\u9519\u8bef!=\u4fe1\u606f\uff1a" + notEqualsTo.toString());
        }
        if (expression instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)expression;
            if (binaryExpression.getLeftExpression() instanceof Function) {
                Function function = (Function)binaryExpression.getLeftExpression();
                throw new MybatisPlusException("\u975e\u6cd5SQL\uff0cwhere\u6761\u4ef6\u4e2d\u4e0d\u80fd\u4f7f\u7528\u6570\u636e\u5e93\u51fd\u6570\uff0c\u9519\u8bef\u51fd\u6570\u4fe1\u606f\uff1a" + function.toString());
            }
            if (binaryExpression.getRightExpression() instanceof SubSelect) {
                SubSelect subSelect = (SubSelect)binaryExpression.getRightExpression();
                throw new MybatisPlusException("\u975e\u6cd5SQL\uff0cwhere\u6761\u4ef6\u4e2d\u4e0d\u80fd\u4f7f\u7528\u5b50\u67e5\u8be2\uff0c\u9519\u8bef\u5b50\u67e5\u8be2SQL\u4fe1\u606f\uff1a" + subSelect.toString());
            }
        } else if (expression instanceof InExpression && (inExpression = (InExpression)expression).getRightItemsList() instanceof SubSelect) {
            SubSelect subSelect = (SubSelect)inExpression.getRightItemsList();
            throw new MybatisPlusException("\u975e\u6cd5SQL\uff0cwhere\u6761\u4ef6\u4e2d\u4e0d\u80fd\u4f7f\u7528\u5b50\u67e5\u8be2\uff0c\u9519\u8bef\u5b50\u67e5\u8be2SQL\u4fe1\u606f\uff1a" + subSelect.toString());
        }
    }

    private static void validJoins(List<Join> joins, Table table, Connection connection) {
        if (joins != null) {
            for (Join join : joins) {
                Table rightTable = (Table)join.getRightItem();
                Expression expression = join.getOnExpression();
                IllegalSQLInterceptor.validWhere(expression, table, rightTable, connection);
            }
        }
    }

    private static void validUseIndex(Table table, String columnName, Connection connection) {
        String tableName;
        boolean useIndexFlag = false;
        String tableInfo = table.getName();
        String dbName = null;
        String[] tableArray = tableInfo.split("\\.");
        if (tableArray.length == 1) {
            tableName = tableArray[0];
        } else {
            dbName = tableArray[0];
            tableName = tableArray[1];
        }
        List<IndexInfo> indexInfos = IllegalSQLInterceptor.getIndexInfos(dbName, tableName, connection);
        for (IndexInfo indexInfo : indexInfos) {
            if (null == columnName || !columnName.equalsIgnoreCase(indexInfo.getColumnName())) continue;
            useIndexFlag = true;
            break;
        }
        if (!useIndexFlag) {
            throw new MybatisPlusException("\u975e\u6cd5SQL\uff0cSQL\u672a\u4f7f\u7528\u5230\u7d22\u5f15, table:" + table + ", columnName:" + columnName);
        }
    }

    private static void validWhere(Expression expression, Table table, Connection connection) {
        IllegalSQLInterceptor.validWhere(expression, table, null, connection);
    }

    private static void validWhere(Expression expression, Table table, Table joinTable, Connection connection) {
        IllegalSQLInterceptor.validExpression(expression);
        if (expression instanceof BinaryExpression) {
            Expression rightExpression;
            Expression leftExpression = ((BinaryExpression)expression).getLeftExpression();
            IllegalSQLInterceptor.validExpression(leftExpression);
            if (leftExpression instanceof Column) {
                rightExpression = ((BinaryExpression)expression).getRightExpression();
                if (joinTable != null && rightExpression instanceof Column) {
                    if (Objects.equals(((Column)rightExpression).getTable().getName(), table.getAlias().getName())) {
                        IllegalSQLInterceptor.validUseIndex(table, ((Column)rightExpression).getColumnName(), connection);
                        IllegalSQLInterceptor.validUseIndex(joinTable, ((Column)leftExpression).getColumnName(), connection);
                    } else {
                        IllegalSQLInterceptor.validUseIndex(joinTable, ((Column)rightExpression).getColumnName(), connection);
                        IllegalSQLInterceptor.validUseIndex(table, ((Column)leftExpression).getColumnName(), connection);
                    }
                } else {
                    IllegalSQLInterceptor.validUseIndex(table, ((Column)leftExpression).getColumnName(), connection);
                }
            } else if (leftExpression instanceof BinaryExpression) {
                IllegalSQLInterceptor.validWhere(leftExpression, table, joinTable, connection);
            }
            rightExpression = ((BinaryExpression)expression).getRightExpression();
            IllegalSQLInterceptor.validExpression(rightExpression);
        }
    }

    public static List<IndexInfo> getIndexInfos(String dbName, String tableName, Connection conn) {
        return IllegalSQLInterceptor.getIndexInfos(null, dbName, tableName, conn);
    }

    public static List<IndexInfo> getIndexInfos(String key, String dbName, String tableName, Connection conn) {
        List<IndexInfo> indexInfos = null;
        if (StringUtils.isNotBlank((CharSequence)key)) {
            indexInfos = indexInfoMap.get(key);
        }
        if (indexInfos == null || indexInfos.isEmpty()) {
            try {
                DatabaseMetaData metadata = conn.getMetaData();
                String catalog = StringUtils.isBlank((CharSequence)dbName) ? conn.getCatalog() : dbName;
                String schema = StringUtils.isBlank((CharSequence)dbName) ? conn.getSchema() : dbName;
                ResultSet rs = metadata.getIndexInfo(catalog, schema, tableName, false, true);
                indexInfos = new ArrayList<IndexInfo>();
                while (rs.next()) {
                    if (!Objects.equals(rs.getString(8), "1")) continue;
                    IndexInfo indexInfo = new IndexInfo();
                    indexInfo.setDbName(rs.getString(1));
                    indexInfo.setTableName(rs.getString(3));
                    indexInfo.setColumnName(rs.getString(9));
                    indexInfos.add(indexInfo);
                }
                if (StringUtils.isNotBlank((CharSequence)key)) {
                    indexInfoMap.put(key, indexInfos);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return indexInfos;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        StatementHandler statementHandler = (StatementHandler)PluginUtils.realTarget((Object)invocation.getTarget());
        MetaObject metaObject = SystemMetaObject.forObject((Object)statementHandler);
        MappedStatement mappedStatement = (MappedStatement)metaObject.getValue("delegate.mappedStatement");
        if (SqlCommandType.INSERT.equals((Object)mappedStatement.getSqlCommandType()) || SqlParserHelper.getSqlParserInfo((MetaObject)metaObject)) {
            return invocation.proceed();
        }
        BoundSql boundSql = (BoundSql)metaObject.getValue("delegate.boundSql");
        String originalSql = boundSql.getSql();
        logger.debug("\u68c0\u67e5SQL\u662f\u5426\u5408\u89c4\uff0cSQL:" + originalSql);
        String md5Base64 = EncryptUtils.md5Base64((String)originalSql);
        if (cacheValidResult.contains(md5Base64)) {
            logger.debug("\u8be5SQL\u5df2\u9a8c\u8bc1\uff0c\u65e0\u9700\u518d\u6b21\u9a8c\u8bc1\uff0c\uff0cSQL:" + originalSql);
            return invocation.proceed();
        }
        Connection connection = (Connection)invocation.getArgs()[0];
        Statement statement = CCJSqlParserUtil.parse((String)originalSql);
        Expression where = null;
        Table table = null;
        List joins = null;
        if (statement instanceof Select) {
            PlainSelect plainSelect = (PlainSelect)((Select)statement).getSelectBody();
            where = plainSelect.getWhere();
            table = (Table)plainSelect.getFromItem();
            joins = plainSelect.getJoins();
        } else if (statement instanceof Update) {
            Update update = (Update)statement;
            where = update.getWhere();
            table = update.getTable();
            joins = update.getJoins();
        } else if (statement instanceof Delete) {
            Delete delete = (Delete)statement;
            where = delete.getWhere();
            table = delete.getTable();
            joins = delete.getJoins();
        }
        if (where == null) {
            throw new MybatisPlusException("\u975e\u6cd5SQL\uff0c\u5fc5\u987b\u8981\u6709where\u6761\u4ef6");
        }
        IllegalSQLInterceptor.validWhere(where, table, connection);
        IllegalSQLInterceptor.validJoins(joins, table, connection);
        cacheValidResult.add(md5Base64);
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        if (target instanceof StatementHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    private static class IndexInfo {
        private String dbName;
        private String tableName;
        private String columnName;

        public String getDbName() {
            return this.dbName;
        }

        public String getTableName() {
            return this.tableName;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public void setDbName(String dbName) {
            this.dbName = dbName;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IndexInfo)) {
                return false;
            }
            IndexInfo other = (IndexInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$dbName = this.getDbName();
            String other$dbName = other.getDbName();
            if (this$dbName == null ? other$dbName != null : !this$dbName.equals(other$dbName)) {
                return false;
            }
            String this$tableName = this.getTableName();
            String other$tableName = other.getTableName();
            if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
                return false;
            }
            String this$columnName = this.getColumnName();
            String other$columnName = other.getColumnName();
            return !(this$columnName == null ? other$columnName != null : !this$columnName.equals(other$columnName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof IndexInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $dbName = this.getDbName();
            result = result * 59 + ($dbName == null ? 43 : $dbName.hashCode());
            String $tableName = this.getTableName();
            result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
            String $columnName = this.getColumnName();
            result = result * 59 + ($columnName == null ? 43 : $columnName.hashCode());
            return result;
        }

        public String toString() {
            return "IllegalSQLInterceptor.IndexInfo(dbName=" + this.getDbName() + ", tableName=" + this.getTableName() + ", columnName=" + this.getColumnName() + ")";
        }
    }
}

