/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.EpollProvider;
import io.lettuce.core.KqueueProvider;
import io.lettuce.core.internal.LettuceAssert;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;

class Transports {
    Transports() {
    }

    static Class<? extends EventLoopGroup> eventLoopGroupClass() {
        if (NativeTransports.isSocketSupported()) {
            return NativeTransports.eventLoopGroupClass();
        }
        return NioEventLoopGroup.class;
    }

    static Class<? extends Channel> socketChannelClass() {
        if (NativeTransports.isSocketSupported()) {
            return NativeTransports.socketChannelClass();
        }
        return NioSocketChannel.class;
    }

    static class NativeTransports {
        NativeTransports() {
        }

        static boolean isSocketSupported() {
            return EpollProvider.isAvailable() || KqueueProvider.isAvailable();
        }

        static Class<? extends Channel> socketChannelClass() {
            if (KqueueProvider.isAvailable()) {
                return KqueueProvider.socketChannelClass();
            }
            return EpollProvider.socketChannelClass();
        }

        static Class<? extends Channel> domainSocketChannelClass() {
            if (KqueueProvider.isAvailable()) {
                return KqueueProvider.domainSocketChannelClass();
            }
            return EpollProvider.domainSocketChannelClass();
        }

        static Class<? extends EventLoopGroup> eventLoopGroupClass() {
            if (KqueueProvider.isAvailable()) {
                return KqueueProvider.eventLoopGroupClass();
            }
            return EpollProvider.eventLoopGroupClass();
        }

        static void assertAvailable() {
            LettuceAssert.assertState(NativeTransports.isSocketSupported(), "A unix domain socket connections requires epoll or kqueue and neither is available");
        }
    }
}

