/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.util;

import java.io.IOException;
import java.io.Writer;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.TemplateModel;
import org.thymeleaf.util.AbstractLazyCharSequence;
import org.thymeleaf.util.FastStringWriter;

public final class LazyProcessingCharSequence
extends AbstractLazyCharSequence {
    private final ITemplateContext context;
    private final TemplateModel templateModel;

    public LazyProcessingCharSequence(ITemplateContext context, TemplateModel templateModel) {
        if (context == null) {
            throw new IllegalArgumentException("Template Context is null, which is forbidden");
        }
        if (templateModel == null) {
            throw new IllegalArgumentException("Template Model is null, which is forbidden");
        }
        this.context = context;
        this.templateModel = templateModel;
    }

    @Override
    protected String resolveText() {
        FastStringWriter stringWriter = new FastStringWriter();
        this.context.getConfiguration().getTemplateManager().process(this.templateModel, this.context, stringWriter);
        return ((Object)stringWriter).toString();
    }

    @Override
    protected void writeUnresolved(Writer writer) throws IOException {
        this.context.getConfiguration().getTemplateManager().process(this.templateModel, this.context, writer);
    }
}

