/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mobile.device.annotation;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.mobile.device.DeviceHandlerMethodArgumentResolver;
import org.springframework.mobile.device.DeviceResolver;
import org.springframework.mobile.device.DeviceResolverHandlerInterceptor;
import org.springframework.mobile.device.annotation.DeviceResolverConfigurer;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class DeviceResolverConfiguration {
    private static final Log logger = LogFactory.getLog(DeviceResolverConfiguration.class);
    private List<DeviceResolverConfigurer> deviceResolverConfigurers = new ArrayList<DeviceResolverConfigurer>();

    @Autowired(required=false)
    public void setDeviceResolverConfigurers(List<DeviceResolverConfigurer> deviceResolverConfigurers) {
        this.deviceResolverConfigurers.addAll(deviceResolverConfigurers);
    }

    @Bean
    public DeviceResolverHandlerInterceptor deviceResolverHandlerInterceptor() {
        for (DeviceResolverConfigurer configurer : this.deviceResolverConfigurers) {
            DeviceResolver deviceResolver = configurer.getDeviceResolver();
            if (deviceResolver == null) continue;
            logger.info((Object)"Using custom DeviceResolver");
            return new DeviceResolverHandlerInterceptor(deviceResolver);
        }
        return new DeviceResolverHandlerInterceptor();
    }

    @Bean
    public DeviceHandlerMethodArgumentResolver deviceHandlerMethodArgumentResolver() {
        return new DeviceHandlerMethodArgumentResolver();
    }

    @Configuration
    @Order(value=0)
    protected static class DeviceResolverMvcConfiguration
    implements WebMvcConfigurer {
        private DeviceResolverHandlerInterceptor deviceResolverHandlerInterceptor;
        private DeviceHandlerMethodArgumentResolver deviceHandlerMethodArgumentResolver;

        protected DeviceResolverMvcConfiguration(DeviceResolverHandlerInterceptor deviceResolverHandlerInterceptor, DeviceHandlerMethodArgumentResolver deviceHandlerMethodArgumentResolver) {
            this.deviceResolverHandlerInterceptor = deviceResolverHandlerInterceptor;
            this.deviceHandlerMethodArgumentResolver = deviceHandlerMethodArgumentResolver;
        }

        public void addInterceptors(InterceptorRegistry registry) {
            registry.addInterceptor((HandlerInterceptor)this.deviceResolverHandlerInterceptor);
        }

        public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
            argumentResolvers.add(this.deviceHandlerMethodArgumentResolver);
        }
    }
}

