/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mobile.device.switcher.annotation;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.mobile.device.switcher.SiteSwitcherHandler;
import org.springframework.mobile.device.switcher.SiteSwitcherHandlerInterceptor;
import org.springframework.mobile.device.switcher.annotation.SiteSwitcherConfigurer;
import org.springframework.util.Assert;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class SiteSwitcherConfiguration {
    private List<SiteSwitcherConfigurer> siteSwitcherConfigurers = new ArrayList<SiteSwitcherConfigurer>();

    @Autowired(required=false)
    public void setSiteSwitcherConfigurers(List<SiteSwitcherConfigurer> siteSwitcherConfigurers) {
        Assert.notNull(siteSwitcherConfigurers, (String)"At least one configuration class must implement SiteSwitcherConfigurer");
        Assert.notEmpty(siteSwitcherConfigurers, (String)"At least one configuration class must implement SiteSwitcherConfigurer");
        this.siteSwitcherConfigurers.addAll(siteSwitcherConfigurers);
    }

    @Bean
    public SiteSwitcherHandlerInterceptor siteSwitcherHandlerInterceptor() {
        for (SiteSwitcherConfigurer configurer : this.siteSwitcherConfigurers) {
            SiteSwitcherHandler siteSwitcherHandler = configurer.getSiteSwitcherHandler();
            if (siteSwitcherHandler == null) continue;
            return new SiteSwitcherHandlerInterceptor(siteSwitcherHandler);
        }
        throw new IllegalStateException("One configuration class must implement getSiteSwitcherHandler from SiteSwitcherConfigurer.");
    }

    @Configuration
    protected static class SiteSwitcherMvcConfiguration
    implements WebMvcConfigurer {
        private final SiteSwitcherHandlerInterceptor siteSwitcherHandlerInterceptor;

        protected SiteSwitcherMvcConfiguration(SiteSwitcherHandlerInterceptor siteSwitcherHandlerInterceptor) {
            this.siteSwitcherHandlerInterceptor = siteSwitcherHandlerInterceptor;
        }

        public void addInterceptors(InterceptorRegistry registry) {
            registry.addInterceptor((HandlerInterceptor)this.siteSwitcherHandlerInterceptor);
        }
    }
}

