/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.health;

import java.util.LinkedHashMap;
import java.util.Set;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthAggregator;
import org.springframework.boot.actuate.health.Status;
import org.springframework.boot.actuate.health.StatusAggregator;

class HealthAggregatorStatusAggregatorAdapter
implements StatusAggregator {
    private HealthAggregator healthAggregator;

    HealthAggregatorStatusAggregatorAdapter(HealthAggregator healthAggregator) {
        this.healthAggregator = healthAggregator;
    }

    public Status getAggregateStatus(Set<Status> statuses) {
        int index = 0;
        LinkedHashMap<String, Health> healths = new LinkedHashMap<String, Health>();
        for (Status status : statuses) {
            healths.put("health" + ++index, this.asHealth(status));
        }
        Health aggregate = this.healthAggregator.aggregate(healths);
        return aggregate.getStatus();
    }

    private Health asHealth(Status status) {
        return Health.status((Status)status).build();
    }
}

