/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.masterslave;

import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.codec.StringCodec;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.masterslave.Exceptions;
import io.lettuce.core.masterslave.RedisMasterSlaveNode;
import io.lettuce.core.masterslave.ResumeAfter;
import io.lettuce.core.masterslave.TopologyProvider;
import io.lettuce.core.models.role.RedisInstance;
import io.lettuce.core.models.role.RedisNodeDescription;
import io.lettuce.core.sentinel.api.StatefulRedisSentinelConnection;
import io.lettuce.core.sentinel.api.reactive.RedisSentinelReactiveCommands;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

@Deprecated
public class SentinelTopologyProvider
implements TopologyProvider {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SentinelTopologyProvider.class);
    private final String masterId;
    private final RedisClient redisClient;
    private final RedisURI sentinelUri;
    private final Duration timeout;

    public SentinelTopologyProvider(String masterId, RedisClient redisClient, RedisURI sentinelUri) {
        LettuceAssert.notEmpty(masterId, "MasterId must not be empty");
        LettuceAssert.notNull((Object)redisClient, "RedisClient must not be null");
        LettuceAssert.notNull((Object)sentinelUri, "Sentinel URI must not be null");
        this.masterId = masterId;
        this.redisClient = redisClient;
        this.sentinelUri = sentinelUri;
        this.timeout = sentinelUri.getTimeout();
    }

    @Override
    public List<RedisNodeDescription> getNodes() {
        logger.debug("lookup topology for masterId {}", (Object)this.masterId);
        try {
            return this.getNodesAsync().get(this.timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw Exceptions.bubble(e);
        }
    }

    @Override
    public CompletableFuture<List<RedisNodeDescription>> getNodesAsync() {
        logger.debug("lookup topology for masterId {}", (Object)this.masterId);
        Mono connect = Mono.fromFuture(this.redisClient.connectSentinelAsync(StringCodec.UTF8, this.sentinelUri));
        return connect.flatMap(this::getNodes).toFuture();
    }

    protected Mono<List<RedisNodeDescription>> getNodes(StatefulRedisSentinelConnection<String, String> connection) {
        RedisSentinelReactiveCommands<String, String> reactive = connection.reactive();
        Mono masterAndSlaves = reactive.master(this.masterId).zipWith(reactive.slaves(this.masterId).collectList()).timeout(this.timeout).flatMap(tuple -> ResumeAfter.close(connection).thenEmit(tuple)).doOnError(e -> connection.closeAsync());
        return masterAndSlaves.map(tuple -> {
            ArrayList<RedisNodeDescription> result = new ArrayList<RedisNodeDescription>();
            result.add(this.toNode((Map)tuple.getT1(), RedisInstance.Role.MASTER));
            result.addAll(((List)tuple.getT2()).stream().filter(SentinelTopologyProvider::isAvailable).map(map -> this.toNode((Map<String, String>)map, RedisInstance.Role.SLAVE)).collect(Collectors.toList()));
            return result;
        });
    }

    private static boolean isAvailable(Map<String, String> map) {
        String flags = map.get("flags");
        return flags == null || !flags.contains("s_down") && !flags.contains("o_down") && !flags.contains("disconnected");
    }

    private RedisNodeDescription toNode(Map<String, String> map, RedisInstance.Role role) {
        String ip = map.get("ip");
        String port = map.get("port");
        return new RedisMasterSlaveNode(ip, Integer.parseInt(port), this.sentinelUri, role);
    }
}

