/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.pubsub;

import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.output.IntegerOutput;
import io.lettuce.core.output.KeyListOutput;
import io.lettuce.core.output.MapOutput;
import io.lettuce.core.protocol.BaseRedisCommandBuilder;
import io.lettuce.core.protocol.Command;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandKeyword;
import io.lettuce.core.protocol.CommandType;
import io.lettuce.core.pubsub.PubSubCommandArgs;
import io.lettuce.core.pubsub.PubSubOutput;
import java.util.List;
import java.util.Map;

class PubSubCommandBuilder<K, V>
extends BaseRedisCommandBuilder<K, V> {
    static final String MUST_NOT_BE_EMPTY = "must not be empty";

    PubSubCommandBuilder(RedisCodec<K, V> codec) {
        super(codec);
    }

    Command<K, V, Long> publish(K channel, V message) {
        CommandArgs args = new PubSubCommandArgs(this.codec).addKey(channel).addValue(message);
        return this.createCommand(CommandType.PUBLISH, new IntegerOutput(this.codec), args);
    }

    Command<K, V, List<K>> pubsubChannels(K pattern) {
        CommandArgs args = new PubSubCommandArgs(this.codec).add(CommandKeyword.CHANNELS).addKey(pattern);
        return this.createCommand(CommandType.PUBSUB, new KeyListOutput(this.codec), args);
    }

    @SafeVarargs
    final Command<K, V, Map<K, Long>> pubsubNumsub(K ... patterns) {
        LettuceAssert.notEmpty((Object[])patterns, "patterns must not be empty");
        CommandArgs args = new PubSubCommandArgs(this.codec).add(CommandKeyword.NUMSUB).addKeys(patterns);
        return this.createCommand(CommandType.PUBSUB, new MapOutput(this.codec), args);
    }

    @SafeVarargs
    final Command<K, V, K> psubscribe(K ... patterns) {
        LettuceAssert.notEmpty((Object[])patterns, "patterns must not be empty");
        return this.pubSubCommand(CommandType.PSUBSCRIBE, new PubSubOutput(this.codec), patterns);
    }

    @SafeVarargs
    final Command<K, V, K> punsubscribe(K ... patterns) {
        return this.pubSubCommand(CommandType.PUNSUBSCRIBE, new PubSubOutput(this.codec), patterns);
    }

    @SafeVarargs
    final Command<K, V, K> subscribe(K ... channels) {
        LettuceAssert.notEmpty((Object[])channels, "channels must not be empty");
        return this.pubSubCommand(CommandType.SUBSCRIBE, new PubSubOutput(this.codec), channels);
    }

    @SafeVarargs
    final Command<K, V, K> unsubscribe(K ... channels) {
        return this.pubSubCommand(CommandType.UNSUBSCRIBE, new PubSubOutput(this.codec), channels);
    }

    <T> Command<K, V, T> pubSubCommand(CommandType type, CommandOutput<K, V, T> output, K ... keys) {
        return new Command<K, V, T>(type, output, new PubSubCommandArgs(this.codec).addKeys(keys));
    }
}

