/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mobile.device.site.annotation;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.mobile.device.site.SitePreferenceHandler;
import org.springframework.mobile.device.site.SitePreferenceHandlerInterceptor;
import org.springframework.mobile.device.site.SitePreferenceHandlerMethodArgumentResolver;
import org.springframework.mobile.device.site.annotation.SitePreferenceConfigurer;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class SitePreferenceConfiguration {
    private static final Log logger = LogFactory.getLog(SitePreferenceConfiguration.class);
    private List<SitePreferenceConfigurer> sitePreferenceConfigurers = new ArrayList<SitePreferenceConfigurer>();

    @Autowired(required=false)
    public void setSitePreferenceConfigurers(List<SitePreferenceConfigurer> sitePreferenceConfigurers) {
        this.sitePreferenceConfigurers.addAll(sitePreferenceConfigurers);
    }

    @Bean
    public SitePreferenceHandlerInterceptor sitePreferenceHandlerInterceptor() {
        for (SitePreferenceConfigurer configurer : this.sitePreferenceConfigurers) {
            SitePreferenceHandler sitePreferenceHandler = configurer.getSitePreferenceHandler();
            if (sitePreferenceHandler == null) continue;
            logger.info((Object)"Using custom SitePreferenceHandler");
            return new SitePreferenceHandlerInterceptor(sitePreferenceHandler);
        }
        return new SitePreferenceHandlerInterceptor();
    }

    @Bean
    public SitePreferenceHandlerMethodArgumentResolver sitePreferenceHandlerMethodArgumentResolver() {
        return new SitePreferenceHandlerMethodArgumentResolver();
    }

    @Configuration
    protected static class SitePreferenceMvcConfiguration
    implements WebMvcConfigurer {
        private final SitePreferenceHandlerInterceptor sitePreferenceHandlerInterceptor;
        private final SitePreferenceHandlerMethodArgumentResolver sitePreferenceHandlerMethodArgumentResolver;

        protected SitePreferenceMvcConfiguration(SitePreferenceHandlerInterceptor sitePreferenceHandlerInterceptor, SitePreferenceHandlerMethodArgumentResolver sitePreferenceHandlerMethodArgumentResolver) {
            this.sitePreferenceHandlerInterceptor = sitePreferenceHandlerInterceptor;
            this.sitePreferenceHandlerMethodArgumentResolver = sitePreferenceHandlerMethodArgumentResolver;
        }

        public void addInterceptors(InterceptorRegistry registry) {
            registry.addInterceptor((HandlerInterceptor)this.sitePreferenceHandlerInterceptor);
        }

        public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
            argumentResolvers.add(this.sitePreferenceHandlerMethodArgumentResolver);
        }
    }
}

