/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api.condition;

import java.util.Arrays;
import java.util.Optional;
import org.junit.jupiter.api.condition.EnabledOnOs;
import org.junit.jupiter.api.condition.OS;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.Preconditions;

class EnabledOnOsCondition
implements ExecutionCondition {
    private static final ConditionEvaluationResult ENABLED_BY_DEFAULT = ConditionEvaluationResult.enabled("@EnabledOnOs is not present");
    static final ConditionEvaluationResult ENABLED_ON_CURRENT_OS = ConditionEvaluationResult.enabled("Enabled on operating system: " + System.getProperty("os.name"));
    static final ConditionEvaluationResult DISABLED_ON_CURRENT_OS = ConditionEvaluationResult.disabled("Disabled on operating system: " + System.getProperty("os.name"));

    EnabledOnOsCondition() {
    }

    @Override
    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        Optional optional = AnnotationUtils.findAnnotation(context.getElement(), EnabledOnOs.class);
        if (optional.isPresent()) {
            OS[] operatingSystems = ((EnabledOnOs)optional.get()).value();
            Preconditions.condition((operatingSystems.length > 0 ? 1 : 0) != 0, (String)"You must declare at least one OS in @EnabledOnOs");
            return Arrays.stream(operatingSystems).anyMatch(OS::isCurrentOs) ? ENABLED_ON_CURRENT_OS : DISABLED_ON_CURRENT_OS;
        }
        return ENABLED_BY_DEFAULT;
    }
}

