/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.invoker.cache;

import java.security.Principal;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.boot.actuate.endpoint.InvocationContext;
import org.springframework.boot.actuate.endpoint.http.ApiVersion;
import org.springframework.boot.actuate.endpoint.invoke.OperationInvoker;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CachingOperationInvoker
implements OperationInvoker {
    private static final boolean IS_REACTOR_PRESENT = ClassUtils.isPresent((String)"reactor.core.publisher.Mono", null);
    private final OperationInvoker invoker;
    private final long timeToLive;
    private final Map<CacheKey, CachedResponse> cachedResponses;

    CachingOperationInvoker(OperationInvoker invoker, long timeToLive) {
        Assert.isTrue((timeToLive > 0L ? 1 : 0) != 0, (String)"TimeToLive must be strictly positive");
        this.invoker = invoker;
        this.timeToLive = timeToLive;
        this.cachedResponses = new ConcurrentHashMap<CacheKey, CachedResponse>();
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    @Override
    public Object invoke(InvocationContext context) {
        if (this.hasInput(context)) {
            return this.invoker.invoke(context);
        }
        long accessTime = System.currentTimeMillis();
        ApiVersion contextApiVersion = context.getApiVersion();
        CacheKey cacheKey = new CacheKey(contextApiVersion, context.getSecurityContext().getPrincipal());
        CachedResponse cached = this.cachedResponses.get(cacheKey);
        if (cached == null || cached.isStale(accessTime, this.timeToLive)) {
            Object response = this.invoker.invoke(context);
            cached = this.createCachedResponse(response, accessTime);
            this.cachedResponses.put(cacheKey, cached);
        }
        return cached.getResponse();
    }

    private boolean hasInput(InvocationContext context) {
        Map<String, Object> arguments = context.getArguments();
        if (!ObjectUtils.isEmpty(arguments)) {
            return arguments.values().stream().anyMatch(Objects::nonNull);
        }
        return false;
    }

    private CachedResponse createCachedResponse(Object response, long accessTime) {
        if (IS_REACTOR_PRESENT) {
            return new ReactiveCachedResponse(response, accessTime, this.timeToLive);
        }
        return new CachedResponse(response, accessTime);
    }

    @Deprecated
    public static OperationInvoker apply(OperationInvoker invoker, long timeToLive) {
        if (timeToLive > 0L) {
            return new CachingOperationInvoker(invoker, timeToLive);
        }
        return invoker;
    }

    private static final class CacheKey {
        private final ApiVersion apiVersion;
        private final Principal principal;

        private CacheKey(ApiVersion apiVersion, Principal principal) {
            this.principal = principal;
            this.apiVersion = apiVersion;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            return this.apiVersion.equals((Object)other.apiVersion) && ObjectUtils.nullSafeEquals((Object)this.principal, (Object)other.principal);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.apiVersion.hashCode();
            result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.principal);
            return result;
        }
    }

    static class ReactiveCachedResponse
    extends CachedResponse {
        ReactiveCachedResponse(Object response, long creationTime, long timeToLive) {
            super(ReactiveCachedResponse.applyCaching(response, timeToLive), creationTime);
        }

        private static Object applyCaching(Object response, long timeToLive) {
            if (response instanceof Mono) {
                return ((Mono)response).cache(Duration.ofMillis(timeToLive));
            }
            if (response instanceof Flux) {
                return ((Flux)response).cache(Duration.ofMillis(timeToLive));
            }
            return response;
        }
    }

    static class CachedResponse {
        private final Object response;
        private final long creationTime;

        CachedResponse(Object response, long creationTime) {
            this.response = response;
            this.creationTime = creationTime;
        }

        boolean isStale(long accessTime, long timeToLive) {
            return accessTime - this.creationTime >= timeToLive;
        }

        Object getResponse() {
            return this.response;
        }
    }
}

