/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.support.collections;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.support.collections.CollectionUtils;
import org.springframework.data.redis.support.collections.RedisCollection;
import org.springframework.data.redis.support.collections.RedisStore;
import org.springframework.lang.Nullable;

public abstract class AbstractRedisCollection<E>
extends AbstractCollection<E>
implements RedisCollection<E> {
    public static final String ENCODING = "UTF-8";
    private volatile String key;
    private final RedisOperations<String, E> operations;

    public AbstractRedisCollection(String key, RedisOperations<String, E> operations) {
        this.key = key;
        this.operations = operations;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public RedisOperations<String, E> getOperations() {
        return this.operations;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean modified = false;
        for (E e : c) {
            modified |= this.add(e);
        }
        return modified;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        boolean contains = true;
        for (Object object : c) {
            contains &= this.contains(object);
        }
        return contains;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        for (Object object : c) {
            modified |= this.remove(object);
        }
        return modified;
    }

    @Override
    public Boolean expire(long timeout, TimeUnit unit) {
        return this.operations.expire(this.key, timeout, unit);
    }

    @Override
    public Boolean expireAt(Date date) {
        return this.operations.expireAt(this.key, date);
    }

    @Override
    public Long getExpire() {
        return this.operations.getExpire(this.key);
    }

    @Override
    public Boolean persist() {
        return this.operations.persist(this.key);
    }

    @Override
    public void rename(String newKey) {
        if (!this.isEmpty()) {
            CollectionUtils.rename(this.key, newKey, this.operations);
        }
        this.key = newKey;
    }

    protected void checkResult(@Nullable Object obj) {
        if (obj == null) {
            throw new IllegalStateException("Cannot read collection with Redis connection in pipeline/multi-exec mode");
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RedisStore) {
            return this.key.equals(((RedisStore)o).getKey());
        }
        if (o instanceof AbstractRedisCollection) {
            return o.hashCode() == this.hashCode();
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = 17 + this.getClass().hashCode();
        result = result * 31 + this.key.hashCode();
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RedisStore for key:");
        sb.append(this.getKey());
        return sb.toString();
    }
}

