/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.repository;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLDeclareItem;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLExprImpl;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLOver;
import com.alibaba.druid.sql.ast.SQLParameter;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExprGroup;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLListExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddConstraint;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableItem;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.alibaba.druid.sql.ast.statement.SQLBlockStatement;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLCreateFunctionStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateProcedureStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLFetchStatement;
import com.alibaba.druid.sql.ast.statement.SQLForeignKeyConstraint;
import com.alibaba.druid.sql.ast.statement.SQLForeignKeyImpl;
import com.alibaba.druid.sql.ast.statement.SQLIfStatement;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLLateralViewTableSource;
import com.alibaba.druid.sql.ast.statement.SQLMergeStatement;
import com.alibaba.druid.sql.ast.statement.SQLReplaceStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableElement;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUniqueConstraint;
import com.alibaba.druid.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.druid.sql.dialect.db2.ast.DB2Object;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2SelectQueryBlock;
import com.alibaba.druid.sql.dialect.db2.visitor.DB2ASTVisitorAdapter;
import com.alibaba.druid.sql.dialect.hive.ast.HiveInsert;
import com.alibaba.druid.sql.dialect.hive.ast.HiveMultiInsertStatement;
import com.alibaba.druid.sql.dialect.hive.visitor.HiveASTVisitorAdapter;
import com.alibaba.druid.sql.dialect.mysql.ast.MysqlForeignKey;
import com.alibaba.druid.sql.dialect.mysql.ast.clause.MySqlCursorDeclareStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.clause.MySqlDeclareStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.clause.MySqlRepeatStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlCreateTableStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlDeleteStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlInsertStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlUpdateStatement;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitorAdapter;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsCreateTableStatement;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsSelectQueryBlock;
import com.alibaba.druid.sql.dialect.odps.visitor.OdpsASTVisitorAdapter;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleCreatePackageStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleCreateTableStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleDeleteStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleForStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleForeignKey;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleInsertStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleMultiInsertStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectQueryBlock;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectSubqueryTableSource;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectTableReference;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleUpdateStatement;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleASTVisitorAdapter;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGDeleteStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGFunctionTableSource;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGInsertStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGSelectQueryBlock;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGSelectStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGUpdateStatement;
import com.alibaba.druid.sql.dialect.postgresql.visitor.PGASTVisitorAdapter;
import com.alibaba.druid.sql.dialect.sqlserver.ast.SQLServerSelectQueryBlock;
import com.alibaba.druid.sql.dialect.sqlserver.ast.stmt.SQLServerInsertStatement;
import com.alibaba.druid.sql.dialect.sqlserver.ast.stmt.SQLServerUpdateStatement;
import com.alibaba.druid.sql.dialect.sqlserver.visitor.SQLServerASTVisitorAdapter;
import com.alibaba.druid.sql.repository.SchemaObject;
import com.alibaba.druid.sql.repository.SchemaRepository;
import com.alibaba.druid.sql.repository.SchemaResolveVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitorAdapter;
import com.alibaba.druid.util.FnvHash;
import com.alibaba.druid.util.PGUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class SchemaResolveVisitorFactory {
    SchemaResolveVisitorFactory() {
    }

    static void resolve(SchemaResolveVisitor visitor, SQLCreateTableStatement x) {
        SchemaRepository repository;
        SchemaResolveVisitor.Context ctx = visitor.createContext(x);
        SQLExprTableSource table = x.getTableSource();
        ctx.setTableSource(table);
        table.accept(visitor);
        List<SQLTableElement> elements = x.getTableElementList();
        for (int i = 0; i < elements.size(); ++i) {
            SQLTableElement e = elements.get(i);
            if (e instanceof SQLColumnDefinition) {
                SQLColumnDefinition columnn = (SQLColumnDefinition)e;
                SQLName columnnName = columnn.getName();
                if (!(columnnName instanceof SQLIdentifierExpr)) continue;
                SQLIdentifierExpr identifierExpr = (SQLIdentifierExpr)columnnName;
                identifierExpr.setResolvedTableSource(table);
                identifierExpr.setResolvedColumn(columnn);
                continue;
            }
            if (e instanceof SQLUniqueConstraint) {
                List<SQLSelectOrderByItem> columns = ((SQLUniqueConstraint)((Object)e)).getColumns();
                for (SQLSelectOrderByItem orderByItem : columns) {
                    SQLExpr orderByItemExpr = orderByItem.getExpr();
                    if (!(orderByItemExpr instanceof SQLIdentifierExpr)) continue;
                    SQLIdentifierExpr identifierExpr = (SQLIdentifierExpr)orderByItemExpr;
                    identifierExpr.setResolvedTableSource(table);
                    SQLColumnDefinition column = x.findColumn(identifierExpr.nameHashCode64());
                    if (column == null) continue;
                    identifierExpr.setResolvedColumn(column);
                }
                continue;
            }
            e.accept(visitor);
        }
        SQLSelect select = x.getSelect();
        if (select != null) {
            visitor.visit(select);
        }
        if ((repository = visitor.getRepository()) != null) {
            repository.acceptCreateTable(x);
        }
        visitor.popContext();
    }

    static void resolve(SchemaResolveVisitor visitor, SQLUpdateStatement x) {
        SQLOrderBy orderBy;
        SchemaResolveVisitor.Context ctx = visitor.createContext(x);
        SQLWithSubqueryClause with = x.getWith();
        if (with != null) {
            with.accept(visitor);
        }
        SQLTableSource table = x.getTableSource();
        SQLTableSource from = x.getFrom();
        ctx.setTableSource(table);
        ctx.setFrom(from);
        table.accept(visitor);
        if (from != null) {
            from.accept(visitor);
        }
        List<SQLUpdateSetItem> items = x.getItems();
        for (SQLUpdateSetItem item : items) {
            SQLExpr value;
            SQLExpr column = item.getColumn();
            if (column instanceof SQLIdentifierExpr) {
                SQLIdentifierExpr identifierExpr = (SQLIdentifierExpr)column;
                identifierExpr.setResolvedTableSource(table);
                visitor.visit(identifierExpr);
            } else if (column instanceof SQLListExpr) {
                SQLListExpr columnGroup = (SQLListExpr)column;
                for (SQLExpr columnGroupItem : columnGroup.getItems()) {
                    if (columnGroupItem instanceof SQLIdentifierExpr) {
                        SQLIdentifierExpr identifierExpr = (SQLIdentifierExpr)columnGroupItem;
                        identifierExpr.setResolvedTableSource(table);
                        visitor.visit(identifierExpr);
                        continue;
                    }
                    columnGroupItem.accept(visitor);
                }
            } else {
                column.accept(visitor);
            }
            if ((value = item.getValue()) == null) continue;
            value.accept(visitor);
        }
        SQLExpr where = x.getWhere();
        if (where != null) {
            where.accept(visitor);
        }
        if ((orderBy = x.getOrderBy()) != null) {
            orderBy.accept(visitor);
        }
        for (SQLExpr sqlExpr : x.getReturning()) {
            sqlExpr.accept(visitor);
        }
        visitor.popContext();
    }

    static void resolve(SchemaResolveVisitor visitor, SQLDeleteStatement x) {
        SQLExpr where;
        SchemaResolveVisitor.Context ctx = visitor.createContext(x);
        SQLWithSubqueryClause with = x.getWith();
        if (with != null) {
            visitor.visit(with);
        }
        SQLTableSource table = x.getTableSource();
        SQLTableSource from = x.getFrom();
        if (from == null) {
            from = x.getUsing();
        }
        if (table == null && from != null) {
            table = from;
            from = null;
        }
        if (from != null) {
            ctx.setFrom(from);
            from.accept(visitor);
        }
        if (table != null) {
            String alias;
            SQLTableSource refTableSource;
            SQLExpr tableExpr;
            if (from != null && table instanceof SQLExprTableSource && (tableExpr = ((SQLExprTableSource)table).getExpr()) instanceof SQLPropertyExpr && ((SQLPropertyExpr)tableExpr).getName().equals("*") && (refTableSource = from.findTableSource(alias = ((SQLPropertyExpr)tableExpr).getOwnernName())) != null) {
                ((SQLPropertyExpr)tableExpr).setResolvedTableSource(refTableSource);
            }
            table.accept(visitor);
            ctx.setTableSource(table);
        }
        if ((where = x.getWhere()) != null) {
            where.accept(visitor);
        }
        visitor.popContext();
    }

    static void resolve(SchemaResolveVisitor visitor, SQLInsertStatement x) {
        SchemaResolveVisitor.Context ctx = visitor.createContext(x);
        SQLWithSubqueryClause with = x.getWith();
        if (with != null) {
            visitor.visit(with);
        }
        SQLExprTableSource table = x.getTableSource();
        ctx.setTableSource(table);
        if (table != null) {
            table.accept(visitor);
        }
        for (SQLExpr column : x.getColumns()) {
            column.accept(visitor);
        }
        for (SQLInsertStatement.ValuesClause valuesClause : x.getValuesList()) {
            valuesClause.accept(visitor);
        }
        SQLSelect query = x.getQuery();
        if (query != null) {
            visitor.visit(query);
        }
        visitor.popContext();
    }

    static void resolve(SchemaResolveVisitor visitor, SQLIdentifierExpr x) {
        SQLExpr expr;
        SQLParameter parameter;
        SQLDeclareItem declareItem;
        SchemaResolveVisitor.Context parentCtx;
        SQLSelectQueryBlock queryBlock;
        SchemaResolveVisitor.Context ctx = visitor.getContext();
        if (ctx == null) {
            return;
        }
        String ident = x.getName();
        long hash = x.nameHashCode64();
        SQLTableSource tableSource = null;
        if (!(hash != FnvHash.Constants.LEVEL && hash != FnvHash.Constants.CONNECT_BY_ISCYCLE || !(ctx.object instanceof SQLSelectQueryBlock) || (queryBlock = (SQLSelectQueryBlock)ctx.object).getStartWith() == null && queryBlock.getConnectBy() == null)) {
            return;
        }
        SQLTableSource ctxTable = ctx.getTableSource();
        if (ctxTable instanceof SQLJoinTableSource) {
            SQLJoinTableSource join = (SQLJoinTableSource)ctxTable;
            tableSource = join.findTableSourceWithColumn(hash);
            if (tableSource == null) {
                SQLTableSource left = join.getLeft();
                SQLTableSource right = join.getRight();
                if (left instanceof SQLSubqueryTableSource && right instanceof SQLExprTableSource) {
                    boolean hasAllColumn;
                    SQLSelect leftSelect = ((SQLSubqueryTableSource)left).getSelect();
                    if (leftSelect.getQuery() instanceof SQLSelectQueryBlock && !(hasAllColumn = ((SQLSelectQueryBlock)leftSelect.getQuery()).selectItemHasAllColumn())) {
                        tableSource = right;
                    }
                } else if (right instanceof SQLSubqueryTableSource && left instanceof SQLExprTableSource) {
                    boolean hasAllColumn;
                    SQLSelect rightSelect = ((SQLSubqueryTableSource)right).getSelect();
                    if (rightSelect.getQuery() instanceof SQLSelectQueryBlock && !(hasAllColumn = ((SQLSelectQueryBlock)rightSelect.getQuery()).selectItemHasAllColumn())) {
                        tableSource = left;
                    }
                } else if (left instanceof SQLExprTableSource && right instanceof SQLExprTableSource) {
                    SQLExprTableSource leftExprTableSource = (SQLExprTableSource)left;
                    SQLExprTableSource rightExprTableSource = (SQLExprTableSource)right;
                    if (leftExprTableSource.getSchemaObject() != null && rightExprTableSource.getSchemaObject() == null) {
                        tableSource = rightExprTableSource;
                    } else if (rightExprTableSource.getSchemaObject() != null && leftExprTableSource.getSchemaObject() == null) {
                        tableSource = leftExprTableSource;
                    }
                }
            }
        } else if (ctxTable instanceof SQLSubqueryTableSource) {
            tableSource = ctxTable.findTableSourceWithColumn(hash);
        } else if (ctxTable instanceof SQLLateralViewTableSource) {
            tableSource = ctxTable.findTableSourceWithColumn(hash);
            if (tableSource == null) {
                tableSource = ((SQLLateralViewTableSource)ctxTable).getTableSource();
            }
        } else {
            SchemaObject table;
            parentCtx = ctx;
            while (parentCtx != null) {
                SQLCreateProcedureStatement createProc;
                declareItem = parentCtx.findDeclare(hash);
                if (declareItem != null) {
                    x.setResolvedDeclareItem(declareItem);
                    return;
                }
                if (parentCtx.object instanceof SQLBlockStatement) {
                    SQLBlockStatement block = (SQLBlockStatement)parentCtx.object;
                    parameter = block.findParameter(hash);
                    if (parameter != null) {
                        x.setResolvedParameter(parameter);
                        return;
                    }
                } else if (parentCtx.object instanceof SQLCreateProcedureStatement && (parameter = (createProc = (SQLCreateProcedureStatement)parentCtx.object).findParameter(hash)) != null) {
                    x.setResolvedParameter(parameter);
                    return;
                }
                parentCtx = parentCtx.parent;
            }
            tableSource = ctxTable;
            if (tableSource instanceof SQLExprTableSource && (table = ((SQLExprTableSource)tableSource).getSchemaObject()) != null && table.findColumn(hash) == null) {
                SQLCreateTableStatement createStmt = null;
                SQLStatement smt = table.getStatement();
                if (smt instanceof SQLCreateTableStatement) {
                    createStmt = (SQLCreateTableStatement)smt;
                }
                if (createStmt != null && createStmt.getTableElementList().size() > 0) {
                    tableSource = null;
                }
            }
        }
        if (tableSource instanceof SQLExprTableSource && (expr = ((SQLExprTableSource)tableSource).getExpr()) instanceof SQLIdentifierExpr) {
            SQLIdentifierExpr identExpr = (SQLIdentifierExpr)expr;
            long identHash = identExpr.nameHashCode64();
            tableSource = SchemaResolveVisitorFactory.unwrapAlias(ctx, tableSource, identHash);
        }
        if (tableSource != null) {
            x.setResolvedTableSource(tableSource);
            SQLColumnDefinition column = tableSource.findColumn(hash);
            if (column != null) {
                x.setResolvedColumn(column);
            }
            if (ctxTable instanceof SQLJoinTableSource) {
                String alias = tableSource.computeAlias();
                if (alias == null || tableSource instanceof SQLWithSubqueryClause.Entry) {
                    return;
                }
                SQLPropertyExpr propertyExpr = new SQLPropertyExpr(new SQLIdentifierExpr(alias), ident, hash);
                propertyExpr.setResolvedColumn(x.getResolvedColumn());
                propertyExpr.setResolvedTableSource(x.getResolvedTableSource());
                SQLUtils.replaceInParent(x, propertyExpr);
            }
        }
        if (x.getResolvedColumn() == null && x.getResolvedTableSource() == null) {
            parentCtx = ctx;
            while (parentCtx != null) {
                SQLCreateProcedureStatement createProc;
                declareItem = parentCtx.findDeclare(hash);
                if (declareItem != null) {
                    x.setResolvedDeclareItem(declareItem);
                    return;
                }
                if (parentCtx.object instanceof SQLBlockStatement) {
                    SQLBlockStatement block = (SQLBlockStatement)parentCtx.object;
                    parameter = block.findParameter(hash);
                    if (parameter != null) {
                        x.setResolvedParameter(parameter);
                        return;
                    }
                } else if (parentCtx.object instanceof SQLCreateProcedureStatement && (parameter = (createProc = (SQLCreateProcedureStatement)parentCtx.object).findParameter(hash)) != null) {
                    x.setResolvedParameter(parameter);
                    return;
                }
                parentCtx = parentCtx.parent;
            }
        }
    }

    static void resolve(SchemaResolveVisitor visitor, SQLPropertyExpr x) {
        SQLTableSource ctxFrom;
        SchemaResolveVisitor.Context ctx = visitor.getContext();
        if (ctx == null) {
            return;
        }
        long owner_hash = 0L;
        SQLExpr ownerObj = x.getOwner();
        if (ownerObj instanceof SQLIdentifierExpr) {
            SQLIdentifierExpr owner = (SQLIdentifierExpr)ownerObj;
            owner_hash = owner.nameHashCode64();
        } else if (ownerObj instanceof SQLPropertyExpr) {
            owner_hash = ((SQLPropertyExpr)ownerObj).hashCode64();
        }
        SQLTableSource tableSource = null;
        SQLTableSource ctxTable = ctx.getTableSource();
        if (ctxTable != null) {
            tableSource = ctxTable.findTableSource(owner_hash);
        }
        if (tableSource == null && (ctxFrom = ctx.getFrom()) != null) {
            tableSource = ctxFrom.findTableSource(owner_hash);
        }
        if (tableSource == null) {
            SchemaResolveVisitor.Context parentCtx = ctx;
            while (parentCtx != null) {
                SQLTableSource parentCtxTable = parentCtx.getTableSource();
                if (parentCtxTable != null) {
                    SQLTableSource ctxFrom2;
                    tableSource = parentCtxTable.findTableSource(owner_hash);
                    if (tableSource == null && (ctxFrom2 = parentCtx.getFrom()) != null) {
                        tableSource = ctxFrom2.findTableSource(owner_hash);
                    }
                    if (tableSource != null) {
                        break;
                    }
                } else {
                    SQLDeclareItem declareItem;
                    SQLMergeStatement mergeStatement;
                    SQLTableSource into;
                    if (parentCtx.object instanceof SQLBlockStatement) {
                        SQLBlockStatement block = (SQLBlockStatement)parentCtx.object;
                        SQLParameter parameter = block.findParameter(owner_hash);
                        if (parameter != null) {
                            x.setResolvedOwnerObject(parameter);
                            return;
                        }
                    } else if (parentCtx.object instanceof SQLMergeStatement && (into = (mergeStatement = (SQLMergeStatement)parentCtx.object).getInto()) instanceof SQLSubqueryTableSource && into.aliasHashCode64() == owner_hash) {
                        x.setResolvedOwnerObject(into);
                    }
                    if ((declareItem = parentCtx.findDeclare(owner_hash)) != null) {
                        SQLObject resolvedObject = declareItem.getResolvedObject();
                        if (!(resolvedObject instanceof SQLCreateProcedureStatement) && !(resolvedObject instanceof SQLCreateFunctionStatement) && !(resolvedObject instanceof SQLTableSource)) break;
                        x.setResolvedOwnerObject(resolvedObject);
                        break;
                    }
                }
                parentCtx = parentCtx.parent;
            }
        }
        if (tableSource != null) {
            x.setResolvedTableSource(tableSource);
            SQLColumnDefinition column = tableSource.findColumn(x.nameHashCode64());
            if (column != null) {
                x.setResolvedColumn(column);
            }
        }
    }

    private static SQLTableSource unwrapAlias(SchemaResolveVisitor.Context ctx, SQLTableSource tableSource, long identHash) {
        SQLTableSource found;
        if (ctx == null) {
            return tableSource;
        }
        if (ctx.object instanceof SQLDeleteStatement && (ctx.getTableSource() == null || tableSource == ctx.getTableSource()) && ctx.getFrom() != null && (found = ctx.getFrom().findTableSource(identHash)) != null) {
            return found;
        }
        SchemaResolveVisitor.Context parentCtx = ctx;
        while (parentCtx != null) {
            SQLWithSubqueryClause.Entry entry;
            SQLWithSubqueryClause with = null;
            if (parentCtx.object instanceof SQLSelect) {
                SQLSelect select = (SQLSelect)parentCtx.object;
                with = select.getWithSubQuery();
            } else if (parentCtx.object instanceof SQLDeleteStatement) {
                SQLDeleteStatement delete = (SQLDeleteStatement)parentCtx.object;
                with = delete.getWith();
            } else if (parentCtx.object instanceof SQLInsertStatement) {
                SQLInsertStatement insertStmt = (SQLInsertStatement)parentCtx.object;
                with = insertStmt.getWith();
            } else if (parentCtx.object instanceof SQLUpdateStatement) {
                SQLUpdateStatement updateStmt = (SQLUpdateStatement)parentCtx.object;
                with = updateStmt.getWith();
            }
            if (with != null && (entry = with.findEntry(identHash)) != null) {
                return entry;
            }
            parentCtx = parentCtx.parent;
        }
        return tableSource;
    }

    static void resolve(SchemaResolveVisitor visitor, SQLSelectQueryBlock x) {
        int forUpdateOfSize;
        SQLOrderBy orderBy;
        SQLSelectGroupByClause groupBy;
        SQLExpr connectBy;
        SQLExpr startWith;
        SQLExpr where;
        HiveMultiInsertStatement insert;
        SchemaResolveVisitor.Context ctx = visitor.createContext(x);
        SQLTableSource from = x.getFrom();
        if (from != null) {
            ctx.setTableSource(from);
            from.accept(visitor);
        } else if (x.getParent() != null && x.getParent().getParent() instanceof HiveInsert && x.getParent().getParent().getParent() instanceof HiveMultiInsertStatement && (insert = (HiveMultiInsertStatement)x.getParent().getParent().getParent()).getFrom() instanceof SQLExprTableSource) {
            from = insert.getFrom();
            ctx.setTableSource(from);
        }
        List<SQLSelectItem> selectList = x.getSelectList();
        ArrayList<SQLSelectItem> columns = new ArrayList<SQLSelectItem>();
        for (int i = selectList.size() - 1; i >= 0; --i) {
            SQLSelectItem selectItem = selectList.get(i);
            SQLExpr expr = selectItem.getExpr();
            if (expr instanceof SQLAllColumnExpr) {
                SQLAllColumnExpr allColumnExpr = (SQLAllColumnExpr)expr;
                allColumnExpr.setResolvedTableSource(from);
                visitor.visit(allColumnExpr);
                if (visitor.isEnabled(SchemaResolveVisitor.Option.ResolveAllColumn)) {
                    SchemaResolveVisitorFactory.extractColumns(visitor, from, columns);
                }
            } else if (expr instanceof SQLPropertyExpr) {
                SQLColumnDefinition column;
                SQLPropertyExpr propertyExpr = (SQLPropertyExpr)expr;
                visitor.visit(propertyExpr);
                String ownerName = propertyExpr.getOwnernName();
                if (propertyExpr.getName().equals("*") && visitor.isEnabled(SchemaResolveVisitor.Option.ResolveAllColumn)) {
                    SQLTableSource tableSource = x.findTableSource(ownerName);
                    SchemaResolveVisitorFactory.extractColumns(visitor, tableSource, columns);
                }
                if ((column = propertyExpr.getResolvedColumn()) != null) continue;
                SQLTableSource tableSource = x.findTableSource(propertyExpr.getOwnernName());
                if (tableSource != null && (column = tableSource.findColumn(propertyExpr.nameHashCode64())) != null) {
                    propertyExpr.setResolvedColumn(column);
                }
            } else if (expr instanceof SQLIdentifierExpr) {
                Iterator identExpr = (SQLIdentifierExpr)expr;
                visitor.visit((SQLIdentifierExpr)((Object)identExpr));
                long name_hash = ((SQLIdentifierExpr)((Object)identExpr)).nameHashCode64();
                Object column = ((SQLIdentifierExpr)((Object)identExpr)).getResolvedColumn();
                if (column != null || from == null) continue;
                column = from.findColumn(name_hash);
                if (column != null) {
                    ((SQLIdentifierExpr)((Object)identExpr)).setResolvedColumn((SQLColumnDefinition)column);
                }
            } else {
                expr.accept(visitor);
            }
            if (columns.size() <= 0) continue;
            for (SQLSelectItem column : columns) {
                column.setParent(x);
                column.getExpr().accept(visitor);
            }
            selectList.remove(i);
            selectList.addAll(i, columns);
        }
        SQLExprTableSource into = x.getInto();
        if (into != null) {
            visitor.visit(into);
        }
        if ((where = x.getWhere()) != null) {
            if (where instanceof SQLBinaryOpExpr) {
                SQLBinaryOpExpr binaryOpExpr = (SQLBinaryOpExpr)where;
                SchemaResolveVisitorFactory.resolveExpr(visitor, binaryOpExpr.getLeft());
                SchemaResolveVisitorFactory.resolveExpr(visitor, binaryOpExpr.getRight());
            } else if (where instanceof SQLBinaryOpExprGroup) {
                SQLBinaryOpExprGroup binaryOpExprGroup = (SQLBinaryOpExprGroup)where;
                for (SQLExpr item : binaryOpExprGroup.getItems()) {
                    if (item instanceof SQLBinaryOpExpr) {
                        SQLBinaryOpExpr binaryOpExpr = (SQLBinaryOpExpr)item;
                        SchemaResolveVisitorFactory.resolveExpr(visitor, binaryOpExpr.getLeft());
                        SchemaResolveVisitorFactory.resolveExpr(visitor, binaryOpExpr.getRight());
                        continue;
                    }
                    item.accept(visitor);
                }
            } else {
                where.accept(visitor);
            }
        }
        if ((startWith = x.getStartWith()) != null) {
            startWith.accept(visitor);
        }
        if ((connectBy = x.getConnectBy()) != null) {
            connectBy.accept(visitor);
        }
        if ((groupBy = x.getGroupBy()) != null) {
            groupBy.accept(visitor);
        }
        if ((orderBy = x.getOrderBy()) != null) {
            for (SQLSelectOrderByItem orderByItem : orderBy.getItems()) {
                SQLIdentifierExpr orderByItemIdentExpr;
                long hash;
                SQLSelectItem selectItem;
                SQLExpr orderByItemExpr = orderByItem.getExpr();
                if (orderByItemExpr instanceof SQLIdentifierExpr && (selectItem = x.findSelectItem(hash = (orderByItemIdentExpr = (SQLIdentifierExpr)orderByItemExpr).nameHashCode64())) != null) {
                    orderByItem.setResolvedSelectItem(selectItem);
                    SQLExpr selectItemExpr = selectItem.getExpr();
                    if (selectItemExpr instanceof SQLIdentifierExpr) {
                        orderByItemIdentExpr.setResolvedTableSource(((SQLIdentifierExpr)selectItemExpr).getResolvedTableSource());
                        orderByItemIdentExpr.setResolvedColumn(((SQLIdentifierExpr)selectItemExpr).getResolvedColumn());
                        continue;
                    }
                    if (!(selectItemExpr instanceof SQLPropertyExpr)) continue;
                    orderByItemIdentExpr.setResolvedTableSource(((SQLPropertyExpr)selectItemExpr).getResolvedTableSource());
                    orderByItemIdentExpr.setResolvedColumn(((SQLPropertyExpr)selectItemExpr).getResolvedColumn());
                    continue;
                }
                orderByItemExpr.accept(visitor);
            }
        }
        if ((forUpdateOfSize = x.getForUpdateOfSize()) > 0) {
            for (SQLExpr sqlExpr : x.getForUpdateOf()) {
                sqlExpr.accept(visitor);
            }
        }
        visitor.popContext();
    }

    static void extractColumns(SchemaResolveVisitor visitor, SQLTableSource from, List<SQLSelectItem> columns) {
        if (from instanceof SQLExprTableSource) {
            SchemaRepository repository = visitor.getRepository();
            if (repository == null) {
                return;
            }
            String alias = from.getAlias();
            SchemaObject table = repository.findTable((SQLExprTableSource)from);
            if (table != null) {
                SQLCreateTableStatement createTableStmt = (SQLCreateTableStatement)table.getStatement();
                for (SQLTableElement e : createTableStmt.getTableElementList()) {
                    SQLExprImpl name;
                    if (!(e instanceof SQLColumnDefinition)) continue;
                    SQLColumnDefinition column = (SQLColumnDefinition)e;
                    if (alias != null) {
                        name = new SQLPropertyExpr(alias, column.getName().getSimpleName());
                        ((SQLPropertyExpr)name).setResolvedColumn(column);
                        columns.add(new SQLSelectItem(name));
                        continue;
                    }
                    name = (SQLIdentifierExpr)column.getName().clone();
                    ((SQLIdentifierExpr)name).setResolvedColumn(column);
                    columns.add(new SQLSelectItem(name));
                }
            }
            return;
        }
        if (from instanceof SQLJoinTableSource) {
            SQLJoinTableSource join = (SQLJoinTableSource)from;
            SchemaResolveVisitorFactory.extractColumns(visitor, join.getLeft(), columns);
            SchemaResolveVisitorFactory.extractColumns(visitor, join.getRight(), columns);
        }
    }

    static void resolve(SchemaResolveVisitor visitor, SQLAllColumnExpr x) {
        SQLTableSource resolvedTableSource;
        SQLExpr expr;
        SQLTableSource tableSource = x.getResolvedTableSource();
        if (tableSource == null) {
            SQLSelectQueryBlock queryBlock = null;
            for (SQLObject parent = x.getParent(); parent != null; parent = parent.getParent()) {
                if (parent instanceof SQLTableSource) {
                    return;
                }
                if (!(parent instanceof SQLSelectQueryBlock)) continue;
                queryBlock = (SQLSelectQueryBlock)parent;
                break;
            }
            if (queryBlock == null) {
                return;
            }
            SQLTableSource from = queryBlock.getFrom();
            if (from == null || from instanceof SQLJoinTableSource) {
                return;
            }
            x.setResolvedTableSource(from);
            tableSource = from;
        }
        if (tableSource instanceof SQLExprTableSource && (expr = ((SQLExprTableSource)tableSource).getExpr()) instanceof SQLIdentifierExpr && (resolvedTableSource = ((SQLIdentifierExpr)expr).getResolvedTableSource()) != null) {
            x.setResolvedTableSource(resolvedTableSource);
        }
    }

    static void resolve(SchemaResolveVisitor visitor, SQLSelect x) {
        SQLSelectQuery query;
        SchemaResolveVisitor.Context ctx = visitor.createContext(x);
        SQLWithSubqueryClause with = x.getWithSubQuery();
        if (with != null) {
            visitor.visit(with);
        }
        if ((query = x.getQuery()) != null) {
            query.accept(visitor);
        }
        SQLSelectQueryBlock queryBlock = x.getFirstQueryBlock();
        SQLOrderBy orderBy = x.getOrderBy();
        if (orderBy != null) {
            for (SQLSelectOrderByItem orderByItem : orderBy.getItems()) {
                SQLExpr orderByItemExpr = orderByItem.getExpr();
                if (orderByItemExpr instanceof SQLIdentifierExpr) {
                    SQLIdentifierExpr orderByItemIdentExpr = (SQLIdentifierExpr)orderByItemExpr;
                    long hash = orderByItemIdentExpr.nameHashCode64();
                    SQLSelectItem selectItem = null;
                    if (queryBlock != null) {
                        selectItem = queryBlock.findSelectItem(hash);
                    }
                    if (selectItem != null) {
                        orderByItem.setResolvedSelectItem(selectItem);
                        SQLExpr selectItemExpr = selectItem.getExpr();
                        if (selectItemExpr instanceof SQLIdentifierExpr) {
                            orderByItemIdentExpr.setResolvedTableSource(((SQLIdentifierExpr)selectItemExpr).getResolvedTableSource());
                            orderByItemIdentExpr.setResolvedColumn(((SQLIdentifierExpr)selectItemExpr).getResolvedColumn());
                            continue;
                        }
                        if (!(selectItemExpr instanceof SQLPropertyExpr)) continue;
                        orderByItemIdentExpr.setResolvedTableSource(((SQLPropertyExpr)selectItemExpr).getResolvedTableSource());
                        orderByItemIdentExpr.setResolvedColumn(((SQLPropertyExpr)selectItemExpr).getResolvedColumn());
                        continue;
                    }
                }
                orderByItemExpr.accept(visitor);
            }
        }
        visitor.popContext();
    }

    static void resolve(SchemaResolveVisitor visitor, SQLWithSubqueryClause x) {
        List<SQLWithSubqueryClause.Entry> entries = x.getEntries();
        for (SQLWithSubqueryClause.Entry entry : entries) {
            SQLSelect query = entry.getSubQuery();
            if (query != null) {
                visitor.visit(query);
                continue;
            }
            entry.getReturningStatement().accept(visitor);
        }
    }

    static void resolve(SchemaResolveVisitor visitor, SQLExprTableSource x) {
        SQLExpr expr = x.getExpr();
        if (expr instanceof SQLName) {
            SQLExpr owner;
            SchemaObject table;
            if (x.getSchemaObject() != null) {
                return;
            }
            SchemaRepository repository = visitor.getRepository();
            if (repository != null && (table = repository.findTable((SQLName)expr)) != null) {
                x.setSchemaObject(table);
            }
            SQLIdentifierExpr identifierExpr = null;
            if (expr instanceof SQLIdentifierExpr) {
                identifierExpr = (SQLIdentifierExpr)expr;
            } else if (expr instanceof SQLPropertyExpr && (owner = ((SQLPropertyExpr)expr).getOwner()) instanceof SQLIdentifierExpr) {
                identifierExpr = (SQLIdentifierExpr)owner;
            }
            if (identifierExpr != null) {
                SchemaResolveVisitorFactory.checkParameter(visitor, identifierExpr);
                SQLTableSource tableSource = SchemaResolveVisitorFactory.unwrapAlias(visitor.getContext(), null, identifierExpr.nameHashCode64());
                if (tableSource != null) {
                    identifierExpr.setResolvedTableSource(tableSource);
                }
            }
        } else if (expr instanceof SQLMethodInvokeExpr) {
            expr.accept(visitor);
        } else {
            expr.accept(visitor);
        }
    }

    static void resolve(SchemaResolveVisitor visitor, SQLAlterTableStatement x) {
        SchemaResolveVisitor.Context ctx = visitor.createContext(x);
        SQLExprTableSource tableSource = x.getTableSource();
        ctx.setTableSource(tableSource);
        for (SQLAlterTableItem item : x.getItems()) {
            item.accept(visitor);
        }
        visitor.popContext();
    }

    static void resolve(SchemaResolveVisitor visitor, SQLMergeStatement x) {
        SQLMergeStatement.MergeInsertClause insertClause;
        SQLMergeStatement.MergeUpdateClause updateClause;
        SQLExpr on;
        SchemaResolveVisitor.Context ctx = visitor.createContext(x);
        SQLTableSource into = x.getInto();
        if (into instanceof SQLExprTableSource) {
            ctx.setTableSource(into);
        } else {
            into.accept(visitor);
        }
        SQLTableSource using = x.getUsing();
        if (using != null) {
            using.accept(visitor);
            ctx.setFrom(using);
        }
        if ((on = x.getOn()) != null) {
            on.accept(visitor);
        }
        if ((updateClause = x.getUpdateClause()) != null) {
            Iterator<SQLExpr> deleteWhere;
            for (SQLUpdateSetItem item : updateClause.getItems()) {
                SQLExpr value;
                SQLExpr column = item.getColumn();
                if (column instanceof SQLIdentifierExpr) {
                    ((SQLIdentifierExpr)column).setResolvedTableSource(into);
                } else if (column instanceof SQLPropertyExpr) {
                    ((SQLPropertyExpr)column).setResolvedTableSource(into);
                } else {
                    column.accept(visitor);
                }
                if ((value = item.getValue()) == null) continue;
                value.accept(visitor);
            }
            SQLExpr where = updateClause.getWhere();
            if (where != null) {
                where.accept(visitor);
            }
            if ((deleteWhere = updateClause.getDeleteWhere()) != null) {
                deleteWhere.accept(visitor);
            }
        }
        if ((insertClause = x.getInsertClause()) != null) {
            for (SQLExpr column : insertClause.getColumns()) {
                if (column instanceof SQLIdentifierExpr) {
                    ((SQLIdentifierExpr)column).setResolvedTableSource(into);
                } else if (column instanceof SQLPropertyExpr) {
                    ((SQLPropertyExpr)column).setResolvedTableSource(into);
                }
                column.accept(visitor);
            }
            for (SQLExpr value : insertClause.getValues()) {
                value.accept(visitor);
            }
            SQLExpr where = insertClause.getWhere();
            if (where != null) {
                where.accept(visitor);
            }
        }
        visitor.popContext();
    }

    static void resolve(SchemaResolveVisitor visitor, SQLCreateFunctionStatement x) {
        SchemaResolveVisitor.Context ctx = visitor.createContext(x);
        SQLDeclareItem declareItem = new SQLDeclareItem(x.getName().clone(), null);
        declareItem.setResolvedObject(x);
        SchemaResolveVisitor.Context parentCtx = visitor.getContext();
        if (parentCtx != null) {
            parentCtx.declare(declareItem);
        } else {
            ctx.declare(declareItem);
        }
        for (SQLParameter parameter : x.getParameters()) {
            parameter.accept(visitor);
        }
        SQLStatement block = x.getBlock();
        if (block != null) {
            block.accept(visitor);
        }
        visitor.popContext();
    }

    static void resolve(SchemaResolveVisitor visitor, SQLCreateProcedureStatement x) {
        SchemaResolveVisitor.Context ctx = visitor.createContext(x);
        SQLDeclareItem declareItem = new SQLDeclareItem(x.getName().clone(), null);
        declareItem.setResolvedObject(x);
        SchemaResolveVisitor.Context parentCtx = visitor.getContext();
        if (parentCtx != null) {
            parentCtx.declare(declareItem);
        } else {
            ctx.declare(declareItem);
        }
        for (SQLParameter parameter : x.getParameters()) {
            parameter.accept(visitor);
        }
        SQLStatement block = x.getBlock();
        if (block != null) {
            block.accept(visitor);
        }
        visitor.popContext();
    }

    static boolean resolve(SchemaResolveVisitor visitor, SQLIfStatement x) {
        SchemaResolveVisitor.Context ctx = visitor.createContext(x);
        SQLExpr condition = x.getCondition();
        if (condition != null) {
            condition.accept(visitor);
        }
        for (SQLStatement stmt : x.getStatements()) {
            stmt.accept(visitor);
        }
        for (SQLIfStatement.ElseIf elseIf : x.getElseIfList()) {
            elseIf.accept(visitor);
        }
        SQLIfStatement.Else e = x.getElseItem();
        if (e != null) {
            e.accept(visitor);
        }
        visitor.popContext();
        return false;
    }

    static void resolve(SchemaResolveVisitor visitor, SQLBlockStatement x) {
        SchemaResolveVisitor.Context ctx = visitor.createContext(x);
        for (SQLParameter parameter : x.getParameters()) {
            visitor.visit(parameter);
        }
        for (SQLStatement stmt : x.getStatementList()) {
            stmt.accept(visitor);
        }
        SQLStatement exception = x.getException();
        if (exception != null) {
            exception.accept(visitor);
        }
        visitor.popContext();
    }

    static void resolve(SchemaResolveVisitor visitor, SQLParameter x) {
        SQLName name = x.getName();
        if (name instanceof SQLIdentifierExpr) {
            ((SQLIdentifierExpr)name).setResolvedParameter(x);
        }
        SQLExpr expr = x.getDefaultValue();
        SchemaResolveVisitor.Context ctx = null;
        if (expr != null) {
            if (expr instanceof SQLQueryExpr) {
                ctx = visitor.createContext(x);
                SQLSubqueryTableSource tableSource = new SQLSubqueryTableSource(((SQLQueryExpr)expr).getSubQuery());
                tableSource.setParent(x);
                tableSource.setAlias(x.getName().getSimpleName());
                ctx.setTableSource(tableSource);
            }
            expr.accept(visitor);
        }
        if (ctx != null) {
            visitor.popContext();
        }
    }

    static void resolve(SchemaResolveVisitor visitor, SQLDeclareItem x) {
        SQLName name;
        SchemaResolveVisitor.Context ctx = visitor.getContext();
        if (ctx != null) {
            ctx.declare(x);
        }
        if ((name = x.getName()) instanceof SQLIdentifierExpr) {
            ((SQLIdentifierExpr)name).setResolvedDeclareItem(x);
        }
    }

    static void resolve(SchemaResolveVisitor visitor, SQLOver x) {
        SQLName of = x.getOf();
        SQLOrderBy orderBy = x.getOrderBy();
        List<SQLExpr> partitionBy = x.getPartitionBy();
        if (of == null && orderBy != null) {
            orderBy.accept(visitor);
        }
        if (partitionBy != null) {
            for (SQLExpr expr : partitionBy) {
                expr.accept(visitor);
            }
        }
    }

    private static boolean checkParameter(SchemaResolveVisitor visitor, SQLIdentifierExpr x) {
        if (x.getResolvedParameter() != null) {
            return true;
        }
        SchemaResolveVisitor.Context ctx = visitor.getContext();
        if (ctx == null) {
            return false;
        }
        long hash = x.hashCode64();
        SchemaResolveVisitor.Context parentCtx = ctx;
        while (parentCtx != null) {
            SQLWithSubqueryClause.Entry entry;
            SQLSelect select;
            SQLWithSubqueryClause with;
            SQLCreateProcedureStatement createProc;
            SQLBlockStatement block;
            SQLParameter parameter;
            if (parentCtx.object instanceof SQLBlockStatement && (parameter = (block = (SQLBlockStatement)parentCtx.object).findParameter(hash)) != null) {
                x.setResolvedParameter(parameter);
                return true;
            }
            if (parentCtx.object instanceof SQLCreateProcedureStatement && (parameter = (createProc = (SQLCreateProcedureStatement)parentCtx.object).findParameter(hash)) != null) {
                x.setResolvedParameter(parameter);
                return true;
            }
            if (parentCtx.object instanceof SQLSelect && (with = (select = (SQLSelect)parentCtx.object).getWithSubQuery()) != null && (entry = with.findEntry(hash)) != null) {
                x.setResolvedTableSource(entry);
                return true;
            }
            SQLDeclareItem declareItem = parentCtx.findDeclare(hash);
            if (declareItem != null) {
                x.setResolvedDeclareItem(declareItem);
                break;
            }
            parentCtx = parentCtx.parent;
        }
        return false;
    }

    static void resolve(SchemaResolveVisitor visitor, SQLReplaceStatement x) {
        SchemaResolveVisitor.Context ctx = visitor.createContext(x);
        SQLExprTableSource tableSource = x.getTableSource();
        ctx.setTableSource(tableSource);
        visitor.visit(tableSource);
        for (SQLExpr column : x.getColumns()) {
            column.accept(visitor);
        }
        SQLQueryExpr queryExpr = x.getQuery();
        if (queryExpr != null) {
            visitor.visit(queryExpr.getSubQuery());
        }
        visitor.popContext();
    }

    static void resolve(SchemaResolveVisitor visitor, SQLFetchStatement x) {
        SchemaResolveVisitorFactory.resolveExpr(visitor, x.getCursorName());
        for (SQLExpr expr : x.getInto()) {
            SchemaResolveVisitorFactory.resolveExpr(visitor, expr);
        }
    }

    static void resolve(SchemaResolveVisitor visitor, SQLForeignKeyConstraint x) {
        SQLIdentifierExpr columnName;
        Object table;
        SchemaRepository repository = visitor.getRepository();
        SQLObject parent = x.getParent();
        if (parent instanceof SQLCreateTableStatement) {
            SQLCreateTableStatement createTableStmt = (SQLCreateTableStatement)parent;
            table = createTableStmt.getTableSource();
            for (SQLName item : x.getReferencingColumns()) {
                columnName = (SQLIdentifierExpr)item;
                columnName.setResolvedTableSource((SQLTableSource)table);
                SQLColumnDefinition column = createTableStmt.findColumn(columnName.nameHashCode64());
                if (column == null) continue;
                columnName.setResolvedColumn(column);
            }
        } else if (parent instanceof SQLAlterTableAddConstraint) {
            SQLAlterTableStatement stmt = (SQLAlterTableStatement)parent.getParent();
            table = stmt.getTableSource();
            for (SQLName item : x.getReferencingColumns()) {
                columnName = (SQLIdentifierExpr)item;
                columnName.setResolvedTableSource((SQLTableSource)table);
            }
        }
        if (repository == null) {
            return;
        }
        SQLExprTableSource table2 = x.getReferencedTable();
        for (SQLName item : x.getReferencedColumns()) {
            SQLIdentifierExpr columnName2 = (SQLIdentifierExpr)item;
            columnName2.setResolvedTableSource(table2);
        }
        SQLName tableName = table2.getName();
        SchemaObject tableObject = repository.findTable(tableName);
        if (tableObject == null) {
            return;
        }
        SQLStatement tableStmt = tableObject.getStatement();
        if (tableStmt instanceof SQLCreateTableStatement) {
            SQLCreateTableStatement refCreateTableStmt = (SQLCreateTableStatement)tableStmt;
            for (SQLName item : x.getReferencedColumns()) {
                SQLIdentifierExpr columnName3 = (SQLIdentifierExpr)item;
                SQLColumnDefinition column = refCreateTableStmt.findColumn(columnName3.nameHashCode64());
                if (column == null) continue;
                columnName3.setResolvedColumn(column);
            }
        }
    }

    static void resolveExpr(SchemaResolveVisitor visitor, SQLExpr x) {
        if (x == null) {
            return;
        }
        Class<?> clazz = x.getClass();
        if (clazz == SQLIdentifierExpr.class) {
            visitor.visit((SQLIdentifierExpr)x);
            return;
        }
        if (clazz == SQLIntegerExpr.class || clazz == SQLCharExpr.class) {
            return;
        }
        x.accept(visitor);
    }

    static class SQLResolveVisitor
    extends SQLASTVisitorAdapter
    implements SchemaResolveVisitor {
        private int options;
        private SchemaRepository repository;
        private SchemaResolveVisitor.Context context;

        public SQLResolveVisitor(SchemaRepository repository, int options) {
            this.repository = repository;
            this.options = options;
        }

        @Override
        public boolean visit(SQLForeignKeyImpl x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLSelectStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x.getSelect());
            return false;
        }

        @Override
        public boolean visit(SQLExprTableSource x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLSelectQueryBlock x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLSelectItem x) {
            SQLExpr expr = x.getExpr();
            if (expr instanceof SQLIdentifierExpr) {
                SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, (SQLIdentifierExpr)expr);
                return false;
            }
            if (expr instanceof SQLPropertyExpr) {
                SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, (SQLPropertyExpr)expr);
                return false;
            }
            return true;
        }

        @Override
        public boolean visit(SQLIdentifierExpr x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return true;
        }

        @Override
        public boolean visit(SQLPropertyExpr x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLAllColumnExpr x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLCreateTableStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLUpdateStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLDeleteStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLSelect x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLWithSubqueryClause x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLInsertStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLAlterTableStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLMergeStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLCreateProcedureStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLBlockStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLParameter x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLDeclareItem x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLOver x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLReplaceStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean isEnabled(SchemaResolveVisitor.Option option) {
            return (this.options & option.mask) != 0;
        }

        @Override
        public SchemaResolveVisitor.Context getContext() {
            return this.context;
        }

        @Override
        public SchemaResolveVisitor.Context createContext(SQLObject object) {
            this.context = new SchemaResolveVisitor.Context(object, this.context);
            return this.context;
        }

        @Override
        public void popContext() {
            if (this.context != null) {
                this.context = this.context.parent;
            }
        }

        @Override
        public SchemaRepository getRepository() {
            return this.repository;
        }
    }

    static class SQLServerResolveVisitor
    extends SQLServerASTVisitorAdapter
    implements SchemaResolveVisitor {
        private int options;
        private SchemaRepository repository;
        private SchemaResolveVisitor.Context context;

        public SQLServerResolveVisitor(SchemaRepository repository, int options) {
            this.repository = repository;
            this.options = options;
        }

        @Override
        public boolean visit(SQLForeignKeyImpl x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLSelectStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x.getSelect());
            return false;
        }

        @Override
        public boolean visit(SQLExprTableSource x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLSelectQueryBlock x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLServerSelectQueryBlock x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLSelectItem x) {
            SQLExpr expr = x.getExpr();
            if (expr instanceof SQLIdentifierExpr) {
                SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, (SQLIdentifierExpr)expr);
                return false;
            }
            if (expr instanceof SQLPropertyExpr) {
                SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, (SQLPropertyExpr)expr);
                return false;
            }
            return true;
        }

        @Override
        public boolean visit(SQLIdentifierExpr x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return true;
        }

        @Override
        public boolean visit(SQLPropertyExpr x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLAllColumnExpr x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLCreateTableStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLUpdateStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLServerUpdateStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLDeleteStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLSelect x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLWithSubqueryClause x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLServerInsertStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLInsertStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLAlterTableStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLMergeStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLCreateProcedureStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLBlockStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLParameter x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLDeclareItem x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLOver x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean isEnabled(SchemaResolveVisitor.Option option) {
            return (this.options & option.mask) != 0;
        }

        @Override
        public SchemaResolveVisitor.Context getContext() {
            return this.context;
        }

        @Override
        public SchemaResolveVisitor.Context createContext(SQLObject object) {
            this.context = new SchemaResolveVisitor.Context(object, this.context);
            return this.context;
        }

        @Override
        public void popContext() {
            if (this.context != null) {
                this.context = this.context.parent;
            }
        }

        @Override
        public SchemaRepository getRepository() {
            return this.repository;
        }
    }

    static class PGResolveVisitor
    extends PGASTVisitorAdapter
    implements SchemaResolveVisitor {
        private int options;
        private SchemaRepository repository;
        private SchemaResolveVisitor.Context context;

        public PGResolveVisitor(SchemaRepository repository, int options) {
            this.repository = repository;
            this.options = options;
        }

        @Override
        public boolean visit(SQLForeignKeyImpl x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLSelectStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x.getSelect());
            return false;
        }

        @Override
        public boolean visit(SQLExprTableSource x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLSelectQueryBlock x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(PGSelectQueryBlock x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(PGFunctionTableSource x) {
            for (SQLParameter parameter : x.getParameters()) {
                SQLName name = parameter.getName();
                if (!(name instanceof SQLIdentifierExpr)) continue;
                SQLIdentifierExpr identName = (SQLIdentifierExpr)name;
                identName.setResolvedTableSource(x);
            }
            return false;
        }

        @Override
        public boolean visit(SQLSelectItem x) {
            SQLExpr expr = x.getExpr();
            if (expr instanceof SQLIdentifierExpr) {
                SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, (SQLIdentifierExpr)expr);
                return false;
            }
            if (expr instanceof SQLPropertyExpr) {
                SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, (SQLPropertyExpr)expr);
                return false;
            }
            return true;
        }

        @Override
        public boolean visit(SQLIdentifierExpr x) {
            if (PGUtils.isPseudoColumn(x.nameHashCode64())) {
                return false;
            }
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return true;
        }

        @Override
        public boolean visit(SQLPropertyExpr x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLAllColumnExpr x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLCreateTableStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLUpdateStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(PGUpdateStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLDeleteStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(PGDeleteStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(PGSelectStatement x) {
            this.createContext(x);
            this.visit(x.getSelect());
            this.popContext();
            return false;
        }

        @Override
        public boolean visit(SQLSelect x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLWithSubqueryClause x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(PGInsertStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLInsertStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLAlterTableStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLMergeStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLCreateProcedureStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLBlockStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLParameter x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLDeclareItem x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLOver x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean isEnabled(SchemaResolveVisitor.Option option) {
            return (this.options & option.mask) != 0;
        }

        @Override
        public SchemaResolveVisitor.Context getContext() {
            return this.context;
        }

        @Override
        public SchemaResolveVisitor.Context createContext(SQLObject object) {
            this.context = new SchemaResolveVisitor.Context(object, this.context);
            return this.context;
        }

        @Override
        public void popContext() {
            if (this.context != null) {
                this.context = this.context.parent;
            }
        }

        @Override
        public SchemaRepository getRepository() {
            return this.repository;
        }
    }

    static class HiveResolveVisitor
    extends HiveASTVisitorAdapter
    implements SchemaResolveVisitor {
        private int options;
        private SchemaRepository repository;
        private SchemaResolveVisitor.Context context;

        public HiveResolveVisitor(SchemaRepository repository, int options) {
            this.repository = repository;
            this.options = options;
        }

        @Override
        public boolean visit(SQLForeignKeyImpl x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLSelectStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x.getSelect());
            return false;
        }

        @Override
        public boolean visit(SQLExprTableSource x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLSelectQueryBlock x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        public boolean visit(OdpsSelectQueryBlock x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLSelectItem x) {
            SQLExpr expr = x.getExpr();
            if (expr instanceof SQLIdentifierExpr) {
                SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, (SQLIdentifierExpr)expr);
                return false;
            }
            if (expr instanceof SQLPropertyExpr) {
                SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, (SQLPropertyExpr)expr);
                return false;
            }
            return true;
        }

        @Override
        public boolean visit(SQLIdentifierExpr x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return true;
        }

        @Override
        public boolean visit(SQLPropertyExpr x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLAllColumnExpr x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLCreateTableStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        public boolean visit(OdpsCreateTableStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLUpdateStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLDeleteStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLSelect x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLWithSubqueryClause x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(HiveInsert x) {
            SchemaResolveVisitor.Context ctx = this.createContext(x);
            SQLExprTableSource tableSource = x.getTableSource();
            if (tableSource != null) {
                ctx.setTableSource(x.getTableSource());
                this.visit(tableSource);
            }
            for (SQLAssignItem item : x.getPartitions()) {
                item.accept(this);
            }
            SQLSelect select = x.getQuery();
            if (select != null) {
                this.visit(select);
            }
            this.popContext();
            return false;
        }

        @Override
        public boolean visit(SQLInsertStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLAlterTableStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLMergeStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLCreateProcedureStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLBlockStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLParameter x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLDeclareItem x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLOver x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean isEnabled(SchemaResolveVisitor.Option option) {
            return (this.options & option.mask) != 0;
        }

        @Override
        public SchemaResolveVisitor.Context getContext() {
            return this.context;
        }

        @Override
        public SchemaResolveVisitor.Context createContext(SQLObject object) {
            this.context = new SchemaResolveVisitor.Context(object, this.context);
            return this.context;
        }

        @Override
        public void popContext() {
            if (this.context != null) {
                this.context = this.context.parent;
            }
        }

        @Override
        public SchemaRepository getRepository() {
            return this.repository;
        }
    }

    static class OdpsResolveVisitor
    extends OdpsASTVisitorAdapter
    implements SchemaResolveVisitor {
        private int options;
        private SchemaRepository repository;
        private SchemaResolveVisitor.Context context;

        public OdpsResolveVisitor(SchemaRepository repository, int options) {
            this.repository = repository;
            this.options = options;
        }

        @Override
        public boolean visit(SQLForeignKeyImpl x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLSelectStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x.getSelect());
            return false;
        }

        @Override
        public boolean visit(SQLExprTableSource x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLSelectQueryBlock x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(OdpsSelectQueryBlock x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLSelectItem x) {
            SQLExpr expr = x.getExpr();
            if (expr instanceof SQLIdentifierExpr) {
                SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, (SQLIdentifierExpr)expr);
                return false;
            }
            if (expr instanceof SQLPropertyExpr) {
                SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, (SQLPropertyExpr)expr);
                return false;
            }
            return true;
        }

        @Override
        public boolean visit(SQLIdentifierExpr x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return true;
        }

        @Override
        public boolean visit(SQLPropertyExpr x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLAllColumnExpr x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLCreateTableStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(OdpsCreateTableStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLUpdateStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLDeleteStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLSelect x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLWithSubqueryClause x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(HiveInsert x) {
            SchemaResolveVisitor.Context ctx = this.createContext(x);
            SQLExprTableSource tableSource = x.getTableSource();
            if (tableSource != null) {
                ctx.setTableSource(x.getTableSource());
                this.visit(tableSource);
            }
            for (SQLAssignItem item : x.getPartitions()) {
                item.accept(this);
            }
            SQLSelect select = x.getQuery();
            if (select != null) {
                this.visit(select);
            }
            this.popContext();
            return false;
        }

        @Override
        public boolean visit(SQLInsertStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLAlterTableStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLMergeStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLCreateProcedureStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLBlockStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLParameter x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLDeclareItem x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLOver x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean isEnabled(SchemaResolveVisitor.Option option) {
            return (this.options & option.mask) != 0;
        }

        @Override
        public SchemaResolveVisitor.Context getContext() {
            return this.context;
        }

        @Override
        public SchemaResolveVisitor.Context createContext(SQLObject object) {
            this.context = new SchemaResolveVisitor.Context(object, this.context);
            return this.context;
        }

        @Override
        public void popContext() {
            if (this.context != null) {
                this.context = this.context.parent;
            }
        }

        @Override
        public SchemaRepository getRepository() {
            return this.repository;
        }
    }

    static class OracleResolveVisitor
    extends OracleASTVisitorAdapter
    implements SchemaResolveVisitor {
        private SchemaRepository repository;
        private int options;
        private SchemaResolveVisitor.Context context;

        public OracleResolveVisitor(SchemaRepository repository, int options) {
            this.repository = repository;
            this.options = options;
        }

        @Override
        public boolean visit(SQLSelectStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x.getSelect());
            return false;
        }

        @Override
        public boolean visit(OracleCreatePackageStatement x) {
            SchemaResolveVisitor.Context ctx = this.createContext(x);
            for (SQLStatement stmt : x.getStatements()) {
                stmt.accept(this);
            }
            this.popContext();
            return false;
        }

        @Override
        public boolean visit(OracleForStatement x) {
            SchemaResolveVisitor.Context ctx = this.createContext(x);
            SQLName index = x.getIndex();
            SQLExpr range = x.getRange();
            if (index != null) {
                SQLDeclareItem declareItem = new SQLDeclareItem(index, null);
                declareItem.setParent(x);
                if (index instanceof SQLIdentifierExpr) {
                    ((SQLIdentifierExpr)index).setResolvedDeclareItem(declareItem);
                }
                declareItem.setResolvedObject(range);
                ctx.declare(declareItem);
                if (range instanceof SQLQueryExpr) {
                    SQLSelect select = ((SQLQueryExpr)range).getSubQuery();
                    SQLSubqueryTableSource tableSource = new SQLSubqueryTableSource(select);
                    declareItem.setResolvedObject(tableSource);
                }
                index.accept(this);
            }
            if (range != null) {
                range.accept(this);
            }
            for (SQLStatement stmt : x.getStatements()) {
                stmt.accept(this);
            }
            this.popContext();
            return false;
        }

        @Override
        public boolean visit(OracleForeignKey x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLIfStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLCreateFunctionStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(OracleSelectTableReference x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLExprTableSource x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLSelectQueryBlock x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(OracleSelectQueryBlock x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLSelectItem x) {
            SQLExpr expr = x.getExpr();
            if (expr instanceof SQLIdentifierExpr) {
                SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, (SQLIdentifierExpr)expr);
                return false;
            }
            if (expr instanceof SQLPropertyExpr) {
                SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, (SQLPropertyExpr)expr);
                return false;
            }
            return true;
        }

        @Override
        public boolean visit(SQLIdentifierExpr x) {
            if (x.nameHashCode64() == FnvHash.Constants.ROWNUM) {
                return false;
            }
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return true;
        }

        @Override
        public boolean visit(SQLPropertyExpr x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLAllColumnExpr x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLCreateTableStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(OracleCreateTableStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLUpdateStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(OracleUpdateStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLDeleteStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(OracleDeleteStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLSelect x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLWithSubqueryClause x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLInsertStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(OracleMultiInsertStatement x) {
            SchemaResolveVisitor.Context ctx = this.createContext(x);
            SQLSelect select = x.getSubQuery();
            this.visit(select);
            OracleSelectSubqueryTableSource tableSource = new OracleSelectSubqueryTableSource(select);
            tableSource.setParent(x);
            ctx.setTableSource(tableSource);
            for (OracleMultiInsertStatement.Entry entry : x.getEntries()) {
                entry.accept(this);
            }
            this.popContext();
            return false;
        }

        @Override
        public boolean visit(OracleMultiInsertStatement.InsertIntoClause x) {
            for (SQLExpr column : x.getColumns()) {
                if (!(column instanceof SQLIdentifierExpr)) continue;
                SQLIdentifierExpr identColumn = (SQLIdentifierExpr)column;
                identColumn.setResolvedTableSource(x.getTableSource());
            }
            return true;
        }

        @Override
        public boolean visit(OracleInsertStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLAlterTableStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLMergeStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLCreateProcedureStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLBlockStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLParameter x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLDeclareItem x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLOver x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLFetchStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean isEnabled(SchemaResolveVisitor.Option option) {
            return (this.options & option.mask) != 0;
        }

        @Override
        public SchemaResolveVisitor.Context getContext() {
            return this.context;
        }

        @Override
        public SchemaResolveVisitor.Context createContext(SQLObject object) {
            this.context = new SchemaResolveVisitor.Context(object, this.context);
            return this.context;
        }

        @Override
        public void popContext() {
            if (this.context != null) {
                this.context = this.context.parent;
            }
        }

        @Override
        public SchemaRepository getRepository() {
            return this.repository;
        }
    }

    static class DB2ResolveVisitor
    extends DB2ASTVisitorAdapter
    implements SchemaResolveVisitor {
        private SchemaRepository repository;
        private int options;
        private SchemaResolveVisitor.Context context;

        public DB2ResolveVisitor(SchemaRepository repository, int options) {
            this.repository = repository;
            this.options = options;
        }

        @Override
        public boolean visit(SQLForeignKeyImpl x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLSelectStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x.getSelect());
            return false;
        }

        @Override
        public boolean visit(SQLExprTableSource x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLSelectQueryBlock x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(DB2SelectQueryBlock x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLSelectItem x) {
            SQLExpr expr = x.getExpr();
            if (expr instanceof SQLIdentifierExpr) {
                SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, (SQLIdentifierExpr)expr);
                return false;
            }
            if (expr instanceof SQLPropertyExpr) {
                SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, (SQLPropertyExpr)expr);
                return false;
            }
            return true;
        }

        @Override
        public boolean visit(SQLIdentifierExpr x) {
            long hash64 = x.hashCode64();
            if (hash64 == DB2Object.Constants.CURRENT_DATE || hash64 == DB2Object.Constants.CURRENT_TIME) {
                return false;
            }
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return true;
        }

        @Override
        public boolean visit(SQLPropertyExpr x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLAllColumnExpr x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLCreateTableStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLUpdateStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLDeleteStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLSelect x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLWithSubqueryClause x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLAlterTableStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLInsertStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLMergeStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLCreateProcedureStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLBlockStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLParameter x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLDeclareItem x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLOver x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean isEnabled(SchemaResolveVisitor.Option option) {
            return (this.options & option.mask) != 0;
        }

        @Override
        public SchemaResolveVisitor.Context getContext() {
            return this.context;
        }

        @Override
        public SchemaResolveVisitor.Context createContext(SQLObject object) {
            this.context = new SchemaResolveVisitor.Context(object, this.context);
            return this.context;
        }

        @Override
        public void popContext() {
            if (this.context != null) {
                this.context = this.context.parent;
            }
        }

        @Override
        public SchemaRepository getRepository() {
            return this.repository;
        }
    }

    static class MySqlResolveVisitor
    extends MySqlASTVisitorAdapter
    implements SchemaResolveVisitor {
        private SchemaRepository repository;
        private int options;
        private SchemaResolveVisitor.Context context;

        public MySqlResolveVisitor(SchemaRepository repository, int options) {
            this.repository = repository;
            this.options = options;
        }

        @Override
        public boolean visit(SQLSelectStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x.getSelect());
            return false;
        }

        @Override
        public boolean visit(MySqlRepeatStatement x) {
            return true;
        }

        @Override
        public boolean visit(MySqlDeclareStatement x) {
            for (SQLDeclareItem declareItem : x.getVarList()) {
                this.visit(declareItem);
            }
            return false;
        }

        @Override
        public boolean visit(MySqlCursorDeclareStatement x) {
            return true;
        }

        @Override
        public boolean visit(MysqlForeignKey x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLExprTableSource x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(MySqlSelectQueryBlock x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLSelectQueryBlock x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLSelectItem x) {
            SQLExpr expr = x.getExpr();
            if (expr instanceof SQLIdentifierExpr) {
                SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, (SQLIdentifierExpr)expr);
                return false;
            }
            if (expr instanceof SQLPropertyExpr) {
                SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, (SQLPropertyExpr)expr);
                return false;
            }
            return true;
        }

        @Override
        public boolean visit(SQLIdentifierExpr x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return true;
        }

        @Override
        public boolean visit(SQLPropertyExpr x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLAllColumnExpr x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(MySqlCreateTableStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            SQLExprTableSource like = x.getLike();
            if (like != null) {
                like.accept(this);
            }
            return false;
        }

        @Override
        public boolean visit(MySqlUpdateStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(MySqlDeleteStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLSelect x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLWithSubqueryClause x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLAlterTableStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(MySqlInsertStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLInsertStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLReplaceStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLMergeStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLCreateProcedureStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLBlockStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLParameter x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLDeclareItem x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLOver x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean isEnabled(SchemaResolveVisitor.Option option) {
            return (this.options & option.mask) != 0;
        }

        @Override
        public SchemaResolveVisitor.Context getContext() {
            return this.context;
        }

        @Override
        public SchemaResolveVisitor.Context createContext(SQLObject object) {
            this.context = new SchemaResolveVisitor.Context(object, this.context);
            return this.context;
        }

        @Override
        public void popContext() {
            if (this.context != null) {
                this.context = this.context.parent;
            }
        }

        @Override
        public SchemaRepository getRepository() {
            return this.repository;
        }
    }
}

