/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.kafka.KafkaClientMetrics;
import io.micrometer.core.instrument.binder.kafka.KafkaStreamsMetrics;
import org.springframework.boot.actuate.autoconfigure.metrics.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.kafka.DefaultKafkaConsumerFactoryCustomizer;
import org.springframework.boot.autoconfigure.kafka.DefaultKafkaProducerFactoryCustomizer;
import org.springframework.boot.autoconfigure.kafka.KafkaAutoConfiguration;
import org.springframework.boot.autoconfigure.kafka.StreamsBuilderFactoryBeanCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.config.StreamsBuilderFactoryBean;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaProducerFactory;
import org.springframework.kafka.core.MicrometerConsumerListener;
import org.springframework.kafka.core.MicrometerProducerListener;
import org.springframework.kafka.core.ProducerFactory;
import org.springframework.kafka.streams.KafkaStreamsMicrometerListener;

@Configuration(proxyBeanMethods=false)
@AutoConfigureBefore(value={KafkaAutoConfiguration.class})
@AutoConfigureAfter(value={MetricsAutoConfiguration.class, CompositeMeterRegistryAutoConfiguration.class})
@ConditionalOnClass(value={KafkaClientMetrics.class, ProducerFactory.class})
@ConditionalOnBean(value={MeterRegistry.class})
public class KafkaMetricsAutoConfiguration {
    @Bean
    public DefaultKafkaProducerFactoryCustomizer kafkaProducerMetrics(MeterRegistry meterRegistry) {
        return producerFactory -> this.addListener(producerFactory, meterRegistry);
    }

    @Bean
    public DefaultKafkaConsumerFactoryCustomizer kafkaConsumerMetrics(MeterRegistry meterRegistry) {
        return consumerFactory -> this.addListener(consumerFactory, meterRegistry);
    }

    private <K, V> void addListener(DefaultKafkaConsumerFactory<K, V> factory, MeterRegistry meterRegistry) {
        factory.addListener((ConsumerFactory.Listener)new MicrometerConsumerListener(meterRegistry));
    }

    private <K, V> void addListener(DefaultKafkaProducerFactory<K, V> factory, MeterRegistry meterRegistry) {
        factory.addListener((ProducerFactory.Listener)new MicrometerProducerListener(meterRegistry));
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={KafkaStreamsMetrics.class, StreamsBuilderFactoryBean.class})
    static class KafkaStreamsMetricsConfiguration {
        KafkaStreamsMetricsConfiguration() {
        }

        @Bean
        StreamsBuilderFactoryBeanCustomizer kafkaStreamsProducerMetrics(MeterRegistry meterRegistry) {
            return factoryBean -> factoryBean.addListener((StreamsBuilderFactoryBean.Listener)new KafkaStreamsMicrometerListener(meterRegistry));
        }
    }
}

