/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint;

import java.util.Map;
import org.springframework.boot.actuate.endpoint.SecurityContext;
import org.springframework.boot.actuate.endpoint.http.ApiVersion;
import org.springframework.util.Assert;

public class InvocationContext {
    private final SecurityContext securityContext;
    private final Map<String, Object> arguments;
    private final ApiVersion apiVersion;

    public InvocationContext(SecurityContext securityContext, Map<String, Object> arguments) {
        this(null, securityContext, arguments);
    }

    public InvocationContext(ApiVersion apiVersion, SecurityContext securityContext, Map<String, Object> arguments) {
        Assert.notNull((Object)securityContext, (String)"SecurityContext must not be null");
        Assert.notNull(arguments, (String)"Arguments must not be null");
        this.apiVersion = apiVersion != null ? apiVersion : ApiVersion.LATEST;
        this.securityContext = securityContext;
        this.arguments = arguments;
    }

    public ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public Map<String, Object> getArguments() {
        return this.arguments;
    }
}

