
// 用于扫描条形码或二维码
function scanCode(obj) {
}


// 用于计算盘点结果
function calculateForLocation(obj) {

}


function updateTableShowForLocation() {

}


layui.use(['form', 'step', 'flow', 'table', 'inputTag'], function () {
    var $ = layui.$,
        form = layui.form,
        table = layui.table,
        inputTag = layui.inputTag,
        dropdown = layui.dropdown, //下拉菜单
        step = layui.step;
    departmentManagerIdForLocation = $("#departmentManagerIdForLocation").val();




    let tagData = [];
    let tempData = $("#departmentManagerForLocation").val().split(",");
    $.each(tempData, function (index, item) {
        if (item !== "") {
            tagData.push(item)
        }
    });
    $("#departmentManagerForLocation").val("");




    let tagLabel1 = inputTag.render({
        elem: '#departmentManagerForLocation',
        data: tagData,//初始值
        removeKeyNum: 8,//删除按键编号 默认，BackSpace 键
        createKeyNum: 13,//创建按键编号 默认，Enter 键
        onChange: function (data, value, type, index) {
            if (type === "remove") {
                let split = departmentManagerIdForLocation.split(",");
                split.splice(index, 1);
                departmentManagerIdForLocation = split.toString();
                $("#departmentManagerIdForLocation").val(departmentManagerIdForLocation);
            }
        }
    });

    // 用于打开负责人树形菜单
    $("#selectdepartmentManagerForLocation").on('click', function () {
        layer.open({
            type: 2,
            title: '弹窗内容',
            skin: 'layui-layer-rim',
            maxmin: true,
            shadeClose: true, //点击遮罩关闭层
            area: ['70%', '70%'],
            move: '.layui-layer-title',
            fixed: false,
            content: '/selectManager?type=Location',
            end: function () {
                departmentManagerIdForLocation = $("#departmentManagerIdForLocation").val();
                tagLabel1.createItem();
            },
            success: function (layero, index) {
                var children = layero.children();
                var content = $(children[1]);
                var iframeChildren = $(content.children());
                content.css('height', '100%');
                iframeChildren.css('height', '100%');
            }
        });
    });


    // 通过位置盘点物料页面
    table.render({
        elem: "#currentTableForLocation",
        url: '/material/findInventoryForStockTaking',
        parseData: function (res) { //res 即为原始返回的数据
            return {
                "status": res.status, //解析接口状态
                "message": res.statusInfo.message, //解析提示文本
                "count": res.count, //解析数据长度
                "data": res.data //解析数据列表
            };
        },
        request: {
            pageName: 'page', //页码的参数名称，默认：page
            limitName: 'size' //每页数据量的参数名，默认：limit
        },
        response: {
            statusName: 'status' //规定数据状态的字段名称，默认：code
            , statusCode: 200 //规定成功的状态码，默认：0
            , msgName: 'message' //规定状态信息的字段名称，默认：msg
            , countName: 'count' //规定数据总数的字段名称，默认：count
            , dataName: 'data' //规定数据列表的字段名称，默认：data
        },
        where: {
            depositoryId: "-1"
        },
        height: 'full-255',//固定高度-即固定表头固定第一行首行
        cols: [
            [
                {field: 'mcode', width: 150, title: '存货编码', fixed: 'left'},
                {field: 'mname', width: 150, title: '物料名称'},
                {field: 'typeName', width: 100, title: '物料种类'},
                {field: 'version', width: 150, title: '规格型号',},
                {field: 'pcode', width: 150, title: '所处库位',},
                {title: '计量单位', width: 200, templet: '#changeUnit', align: "center"},
                {field: 'inventory', width: 100, title: '库存数'},
                {field: 'stockTakingQuantity', width: 100, title: '盘点数', edit: 'quantity'},
                {field: 'takingResultString', width: 100, title: '盘点结果'},
                {field: 'takingInventory', width: 100, title: '盈亏数量'},
                {title: '操作', width: 100, toolbar: '#currentTableBarForMaterial', align: "center"}
            ]
        ],
        limits: [10, 15, 20, 25, 50, 100],
        limit: 10,
        page: true,
        skin: 'line',
        done: function (res, curr, count) {
            $.each(res['data'], function (i, j) {
                let takingUnit = j["takingUnit"];
                if (takingUnit !== null) {
                    let parentItem = $("[lay-id='currentTableForLocation'] tr:eq(" + (i + 1) + ")");
                    let unitHandleItem = parentItem.children()[5];
                    let quantityHandleItem = parentItem.children()[6];
                    unitHandleItem.childNodes[0].childNodes[1].childNodes[0].data = takingUnit;
                    quantityHandleItem.childNodes[0].innerText = j["splitInventory"][takingUnit];
                }
            });
        }
    });


    // 扫码盘点位置
    scanCode = function () {
        parent.wx.scanQRCode({
            desc: 'scanQRCode desc',
            needResult: 1, // 默认为0，扫描结果由企业微信处理，1则直接返回扫描结果，
            scanType: ["qrCode", "barCode"], // 可以指定扫二维码还是条形码（一维码），默认二者都有
            success: function (res) {
                // 回调
                var result = res.resultStr;//当needResult为1时返回处理结果
                var req = {};
                req.qrCode = result;
                req.codeFlag = 2;
                $.ajax({
                    url: "/place/qywxApplicationInScanQrCode",
                    type: "post",
                    dataType: 'json',
                    data: JSON.stringify(req),
                    contentType: "application/json;charset=utf-8",
                    success: function (d) {
                        var data = d.data;
                        var flag = data["flag"];
                        if (flag === 0) {
                            // 如果没有获取到位置
                            layer.msg("并未查询到对应位置，请重新扫描", {
                                icon: 0,
                                time: 1000
                            }, function () {
                                depositoryId = -1;
                                placeId = -1;

                            });
                        } else if (flag === 1) {
                            // 如果获取到的是库位
                            var place = data["place"];
                            $("#placeId").val(place.id);
                            $("#openSonByDepository").val(place.depositoryName);
                            $("#depositoryId").val(place.did);

                            depositoryId = place.did;
                            placeId = place.id;
                        } else if (flag === 2) {
                            // 如果获取到的是仓库
                            var depository = data["depository"];
                            $("#placeId").val("0");
                            $("#openSonByDepository").val(depository.dname);
                            $("#depositoryId").val(depository.id);

                            depositoryId = depository.id;
                            placeId = "0";

                        }
                        updateTableShow();
                    }
                })
            }
        })
    };


    table.on('edit(currentTableFilterForLocation)', function (obj) {
        obj.update({stockTakingQuantity: obj.value});//修改当前行数据
        calculateForLocation(obj);
    });


    // 用于监听下拉菜单
    table.on('tool(currentTableFilterForLocation)', function (obj) { //注：tool 是工具条事件名，test 是 table 原始容器的属性 lay-filter="对应的值"
        var data = obj.data //获得当前行数据
            , layEvent = obj.event; //获得 lay-event 对应的值
        if (layEvent === 'more') {
            let splitInfoList = obj.data.splitInfoList;
            if (splitInfoList.length > 0) {
                let dropDownDataList = [];
                for (var i = 0; i < splitInfoList.length; i++) {
                    let dropDownData = {};
                    dropDownData.title = splitInfoList[i].newUnit;
                    dropDownData.id = obj.data.id;
                    dropDownDataList.push(dropDownData);
                }
                dropdown.render({
                    elem: this //触发事件的 DOM 对象
                    , show: true //外部事件触发即显示
                    , data: dropDownDataList
                    , click: function (unit) {
                        this.elem[0].childNodes[0].data = unit.title;
                        obj.tr[0].childNodes[6].childNodes[0].innerText = obj.data.splitInventory[unit.title];
                    }
                    , align: 'right' //右对齐弹出（v2.6.8 新增）
                    , style: 'box-shadow: 1px 1px 10px rgb(0 0 0 / 12%);' //设置额外样式
                })
            }
            //下拉菜单

        }
        else if(layEvent === "clear"){
            let req = {};
            req.id = obj.data.id + "";
            $.ajax({
                url: "/stockTaking/delTemporaryStorageForTakingResult",
                dataType: "json",
                data: JSON.stringify(req),
                type: "POST",
                contentType: "application/json;charset=utf-8",
                success : function(){
                    updateTableShowForLocation();
                }
            });
        }
    });

    // 用于计算盘点结果
    calculateForLocation = function (obj) {
        let oldInventory = Number(obj.tr[0].childNodes[6].childNodes[0].innerText);
        let nowInventory = Number(obj.value);
        let number = 0;
        let takingResult = '';
        let takingResultString = '';
        let req = {};
        if ((oldInventory) > (nowInventory)) {
            number = oldInventory - nowInventory;
            takingResult = "Inventory_down";
            takingResultString = "盘亏";
        } else if ((oldInventory) < (nowInventory)) {
            number = nowInventory - oldInventory;
            takingResult = "Inventory_up";
            takingResultString = "盘盈";
        } else {
            takingResult = "Inventory_normal";
            takingResultString = "正常";
        }
        obj.tr[0].childNodes[8].childNodes[0].innerText = takingResultString;
        obj.tr[0].childNodes[9].childNodes[0].innerText = number;
        obj.update({takingResult: takingResult});
        obj.update({takingInventory: number});
        req.number = number + "";
        req.takingResult = takingResult;
        req.takingResultString = takingResultString;
        req.id = obj.data.id + "";
        req.unit = obj.tr[0].childNodes[5].childNodes[0].innerText;
        req.oldInventory = oldInventory + "";
        $.ajax({
            url: "/stockTaking/temporaryStorageForTakingResult",
            dataType: "json",
            data: JSON.stringify(req),
            type: "POST",
            contentType: "application/json;charset=utf-8"
        });
    };


    // 用于打开仓库树形菜单
    $('#openSonByDepository').on('click', function () {
        layer.open({
            type: 2,
            title: '弹窗内容',
            skin: 'layui-layer-rim',
            maxmin: true,
            shadeClose: true, //点击遮罩关闭层
            area: ['70%', '70%'],
            move: '.layui-layer-title',
            fixed: false,
            content: '/selectDepository?type=1',
            success: function (layero, index) {
                var children = layero.children();
                var content = $(children[1]);
                var iframeChildren = $(content.children());
                content.css('height', '100%');
                iframeChildren.css('height', '100%');
            },
            end: function () {
                var nowDepositoryId = $("#depositoryId").val();
                var nowPlaceId = $("#placeId").val();
                if (nowDepositoryId !== depositoryId || nowPlaceId !== placeId) {
                    // 如果重新选择盘点位置
                    var nowDepositoryName = $("#openSonByDepository").val();
                    $("#form1")[0].reset();
                    $("#depositoryId").val(nowDepositoryId);
                    $("#placeId").val(nowPlaceId);
                    $("#openSonByDepository").val(nowDepositoryName);
                    form.render();
                }
                if (nowDepositoryId !== null && nowDepositoryId !== "") {
                    depositoryId = nowDepositoryId;
                    placeId = nowPlaceId;
                    updateTableShowForLocation();
                }
                $("#locationCard")[0].reset();

            }
        });
    });


    updateTableShowForLocation = function () {
        let req = {};
        req.depositoryId = depositoryId;
        req.placeId = placeId;
        table.reload('currentTableForLocation', {
            url: '/material/findInventoryForStockTaking',
            page: {
                curr: 1
            },
            where: req
        }, 'data');
    };

});