/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.sparta;

import com.hp.hpl.sparta.Document;
import com.hp.hpl.sparta.DocumentSource;
import com.hp.hpl.sparta.Element;
import com.hp.hpl.sparta.ParseHandler;
import com.hp.hpl.sparta.ParseLog;
import com.hp.hpl.sparta.ParseSource;
import com.hp.hpl.sparta.Text;

class BuildDocument
implements DocumentSource,
ParseHandler {
    private final ParseLog log_;
    private Element currentElement_ = null;
    private final Document doc_ = new Document();
    private ParseSource parseSource_ = null;

    public BuildDocument() {
        this(null);
    }

    public BuildDocument(ParseLog log) {
        this.log_ = log == null ? DEFAULT_LOG : log;
    }

    @Override
    public void setParseSource(ParseSource ps) {
        this.parseSource_ = ps;
        this.doc_.setSystemId(ps.toString());
    }

    @Override
    public ParseSource getParseSource() {
        return this.parseSource_;
    }

    @Override
    public String toString() {
        if (this.parseSource_ != null) {
            return "BuildDoc: " + this.parseSource_.toString();
        }
        return null;
    }

    @Override
    public String getSystemId() {
        if (this.parseSource_ != null) {
            return this.parseSource_.getSystemId();
        }
        return null;
    }

    @Override
    public int getLineNumber() {
        if (this.parseSource_ != null) {
            return this.parseSource_.getLineNumber();
        }
        return -1;
    }

    @Override
    public Document getDocument() {
        return this.doc_;
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void startElement(Element element) {
        if (this.currentElement_ == null) {
            this.doc_.setDocumentElement(element);
        } else {
            this.currentElement_.appendChild(element);
        }
        this.currentElement_ = element;
    }

    @Override
    public void endElement(Element element) {
        this.currentElement_ = this.currentElement_.getParentNode();
    }

    @Override
    public void characters(char[] buf, int offset, int len) {
        Element element = this.currentElement_;
        if (element.getLastChild() instanceof Text) {
            Text text = (Text)element.getLastChild();
            text.appendData(buf, offset, len);
        } else {
            Text text = new Text(new String(buf, offset, len));
            element.appendChildNoChecking(text);
        }
    }
}

