/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.plugins.inner;

import com.baomidou.mybatisplus.core.plugins.InterceptorIgnoreHelper;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.extension.parser.JsqlParserSupport;
import com.baomidou.mybatisplus.extension.plugins.handler.DataPermissionHandler;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import java.sql.SQLException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

public class DataPermissionInterceptor
extends JsqlParserSupport
implements InnerInterceptor {
    private DataPermissionHandler dataPermissionHandler;

    @Override
    public void beforeQuery(Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) throws SQLException {
        if (InterceptorIgnoreHelper.willIgnoreDataPermission((String)ms.getId())) {
            return;
        }
        PluginUtils.MPBoundSql mpBs = PluginUtils.mpBoundSql((BoundSql)boundSql);
        mpBs.sql(this.parserSingle(mpBs.sql(), ms.getId()));
    }

    @Override
    protected void processSelect(Select select, int index, String sql, Object obj) {
        PlainSelect plainSelect = (PlainSelect)select.getSelectBody();
        Expression sqlSegment = this.dataPermissionHandler.getSqlSegment(plainSelect.getWhere(), (String)obj);
        if (null != sqlSegment) {
            plainSelect.setWhere(sqlSegment);
        }
    }

    public DataPermissionHandler getDataPermissionHandler() {
        return this.dataPermissionHandler;
    }

    public void setDataPermissionHandler(DataPermissionHandler dataPermissionHandler) {
        this.dataPermissionHandler = dataPermissionHandler;
    }

    public DataPermissionInterceptor() {
    }

    public DataPermissionInterceptor(DataPermissionHandler dataPermissionHandler) {
        this.dataPermissionHandler = dataPermissionHandler;
    }

    public String toString() {
        return "DataPermissionInterceptor(super=" + super.toString() + ", dataPermissionHandler=" + this.getDataPermissionHandler() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataPermissionInterceptor)) {
            return false;
        }
        DataPermissionInterceptor other = (DataPermissionInterceptor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DataPermissionHandler this$dataPermissionHandler = this.getDataPermissionHandler();
        DataPermissionHandler other$dataPermissionHandler = other.getDataPermissionHandler();
        return !(this$dataPermissionHandler == null ? other$dataPermissionHandler != null : !this$dataPermissionHandler.equals(other$dataPermissionHandler));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataPermissionInterceptor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        DataPermissionHandler $dataPermissionHandler = this.getDataPermissionHandler();
        result = result * 59 + ($dataPermissionHandler == null ? 43 : $dataPermissionHandler.hashCode());
        return result;
    }
}

