/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mobile.device.switcher;

import org.springframework.mobile.device.site.CookieSitePreferenceRepository;
import org.springframework.mobile.device.site.StandardSitePreferenceHandler;
import org.springframework.mobile.device.switcher.MobileSitePathUrlFactory;
import org.springframework.mobile.device.switcher.NormalSitePathUrlFactory;
import org.springframework.mobile.device.switcher.SiteSwitcherHandler;
import org.springframework.mobile.device.switcher.StandardSiteSwitcherHandler;
import org.springframework.mobile.device.switcher.StandardSiteUrlFactory;
import org.springframework.mobile.device.switcher.TabletSitePathUrlFactory;

public class StandardSiteSwitcherHandlerFactory {
    public static SiteSwitcherHandler mDot(String serverName) {
        return StandardSiteSwitcherHandlerFactory.mDot(serverName, false);
    }

    public static SiteSwitcherHandler mDot(String serverName, Boolean tabletIsMobile) {
        return StandardSiteSwitcherHandlerFactory.standard(serverName, "m." + serverName, "." + serverName, tabletIsMobile);
    }

    public static SiteSwitcherHandler dotMobi(String serverName) {
        return StandardSiteSwitcherHandlerFactory.dotMobi(serverName, false);
    }

    public static SiteSwitcherHandler dotMobi(String serverName, Boolean tabletIsMobile) {
        int lastDot = serverName.lastIndexOf(46);
        return StandardSiteSwitcherHandlerFactory.standard(serverName, serverName.substring(0, lastDot) + ".mobi", "." + serverName, tabletIsMobile);
    }

    public static SiteSwitcherHandler standard(String normalServerName, String mobileServerName, String cookieDomain) {
        return StandardSiteSwitcherHandlerFactory.standard(normalServerName, mobileServerName, cookieDomain, false);
    }

    public static SiteSwitcherHandler standard(String normalServerName, String mobileServerName, String cookieDomain, Boolean tabletIsMobile) {
        return new StandardSiteSwitcherHandler(new StandardSiteUrlFactory(normalServerName), new StandardSiteUrlFactory(mobileServerName), null, new StandardSitePreferenceHandler(new CookieSitePreferenceRepository(cookieDomain)), tabletIsMobile);
    }

    public static SiteSwitcherHandler standard(String normalServerName, String mobileServerName, String tabletServerName, String cookieDomain) {
        return new StandardSiteSwitcherHandler(new StandardSiteUrlFactory(normalServerName), new StandardSiteUrlFactory(mobileServerName), new StandardSiteUrlFactory(tabletServerName), new StandardSitePreferenceHandler(new CookieSitePreferenceRepository(cookieDomain)), null);
    }

    public static SiteSwitcherHandler urlPath(String mobilePath) {
        return new StandardSiteSwitcherHandler(new NormalSitePathUrlFactory(mobilePath), new MobileSitePathUrlFactory(mobilePath, null), null, new StandardSitePreferenceHandler(new CookieSitePreferenceRepository()), false);
    }

    public static SiteSwitcherHandler urlPath(String mobilePath, String rootPath) {
        return new StandardSiteSwitcherHandler(new NormalSitePathUrlFactory(mobilePath, rootPath), new MobileSitePathUrlFactory(mobilePath, null, rootPath), null, new StandardSitePreferenceHandler(new CookieSitePreferenceRepository()), false);
    }

    public static SiteSwitcherHandler urlPath(String mobilePath, String tabletPath, String rootPath) {
        return new StandardSiteSwitcherHandler(new NormalSitePathUrlFactory(mobilePath, tabletPath, rootPath), new MobileSitePathUrlFactory(mobilePath, tabletPath, rootPath), new TabletSitePathUrlFactory(tabletPath, mobilePath, rootPath), new StandardSitePreferenceHandler(new CookieSitePreferenceRepository()), null);
    }
}

