/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mobile.autoconfigure;

import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Configuration;
import org.springframework.mobile.autoconfigure.DeviceResolverAutoConfiguration;
import org.springframework.mobile.device.switcher.SiteSwitcherHandler;
import org.springframework.mobile.device.switcher.SiteSwitcherHandlerInterceptor;
import org.springframework.mobile.device.switcher.annotation.EnableSiteSwitcher;
import org.springframework.mobile.device.switcher.annotation.SiteSwitcherConfigurer;

@Configuration
@ConditionalOnClass(value={SiteSwitcherHandlerInterceptor.class})
@AutoConfigureAfter(value={DeviceResolverAutoConfiguration.class})
@ConditionalOnProperty(prefix="spring.mobile.siteswitcher", name={"enabled"}, havingValue="true", matchIfMissing=true)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class SiteSwitcherAutoConfiguration {

    @Configuration
    @ConditionalOnBean(value={SiteSwitcherHandler.class})
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    @EnableSiteSwitcher
    protected static class SiteSwitcherConfigurationAdapter
    implements SiteSwitcherConfigurer {
        private SiteSwitcherHandler siteSwitcherHandler;

        public SiteSwitcherConfigurationAdapter(SiteSwitcherHandler siteSwitcherHandler) {
            this.siteSwitcherHandler = siteSwitcherHandler;
        }

        public SiteSwitcherHandler getSiteSwitcherHandler() {
            return this.siteSwitcherHandler;
        }
    }
}

