/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.health;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.boot.actuate.health.NamedContributor;
import org.springframework.boot.actuate.health.ReactiveHealthContributor;
import org.springframework.boot.actuate.health.ReactiveHealthContributorRegistry;
import org.springframework.boot.actuate.health.ReactiveHealthIndicator;
import org.springframework.boot.actuate.health.ReactiveHealthIndicatorRegistry;
import org.springframework.util.Assert;

class ReactiveHealthContributorRegistryReactiveHealthIndicatorRegistryAdapter
implements ReactiveHealthIndicatorRegistry {
    private final ReactiveHealthContributorRegistry contributorRegistry;

    ReactiveHealthContributorRegistryReactiveHealthIndicatorRegistryAdapter(ReactiveHealthContributorRegistry contributorRegistry) {
        Assert.notNull((Object)contributorRegistry, (String)"ContributorRegistry must not be null");
        this.contributorRegistry = contributorRegistry;
    }

    public void register(String name, ReactiveHealthIndicator healthIndicator) {
        this.contributorRegistry.registerContributor(name, (Object)healthIndicator);
    }

    public ReactiveHealthIndicator unregister(String name) {
        ReactiveHealthContributor contributor = (ReactiveHealthContributor)this.contributorRegistry.unregisterContributor(name);
        if (contributor instanceof ReactiveHealthIndicator) {
            return (ReactiveHealthIndicator)contributor;
        }
        return null;
    }

    public ReactiveHealthIndicator get(String name) {
        ReactiveHealthContributor contributor = (ReactiveHealthContributor)this.contributorRegistry.getContributor(name);
        if (contributor instanceof ReactiveHealthIndicator) {
            return (ReactiveHealthIndicator)contributor;
        }
        return null;
    }

    public Map<String, ReactiveHealthIndicator> getAll() {
        LinkedHashMap<String, ReactiveHealthIndicator> all = new LinkedHashMap<String, ReactiveHealthIndicator>();
        for (NamedContributor namedContributor : this.contributorRegistry) {
            if (!(namedContributor.getContributor() instanceof ReactiveHealthIndicator)) continue;
            all.put(namedContributor.getName(), (ReactiveHealthIndicator)namedContributor.getContributor());
        }
        return all;
    }
}

