/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.map;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.map.MapWrapper;
import java.util.Map;

public class BiMap<K, V>
extends MapWrapper<K, V> {
    private static final long serialVersionUID = 1L;
    private Map<V, K> inverse;

    public BiMap(Map<K, V> raw) {
        super(raw);
    }

    @Override
    public V put(K key, V value) {
        if (null != this.inverse) {
            this.inverse.put(value, key);
        }
        return super.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        super.putAll(m);
        if (null != this.inverse) {
            m.forEach((? super K key, ? super V value) -> this.inverse.put(value, key));
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.inverse = null;
    }

    public Map<V, K> getInverse() {
        if (null == this.inverse) {
            this.inverse = MapUtil.inverse(this.getRaw());
        }
        return this.inverse;
    }

    public K getKey(V value) {
        return this.getInverse().get(value);
    }
}

