/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mobile.device.switcher;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.mobile.device.site.SitePreferenceHandler;
import org.springframework.mobile.device.switcher.SiteSwitcherHandler;
import org.springframework.mobile.device.switcher.SiteUrlFactory;
import org.springframework.mobile.device.switcher.StandardSiteSwitcherHandler;
import org.springframework.mobile.device.switcher.StandardSiteSwitcherHandlerFactory;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class SiteSwitcherHandlerInterceptor
extends HandlerInterceptorAdapter {
    private final SiteSwitcherHandler siteSwitcherHandler;

    public SiteSwitcherHandlerInterceptor(SiteSwitcherHandler siteSwitcherHandler) {
        this.siteSwitcherHandler = siteSwitcherHandler;
    }

    public SiteSwitcherHandlerInterceptor(SiteUrlFactory normalSiteUrlFactory, SiteUrlFactory mobileSiteUrlFactory, SitePreferenceHandler sitePreferenceHandler) {
        this(normalSiteUrlFactory, mobileSiteUrlFactory, sitePreferenceHandler, false);
    }

    public SiteSwitcherHandlerInterceptor(SiteUrlFactory normalSiteUrlFactory, SiteUrlFactory mobileSiteUrlFactory, SitePreferenceHandler sitePreferenceHandler, Boolean tabletIsMobile) {
        this.siteSwitcherHandler = new StandardSiteSwitcherHandler(normalSiteUrlFactory, mobileSiteUrlFactory, null, sitePreferenceHandler, tabletIsMobile);
    }

    public SiteSwitcherHandlerInterceptor(SiteUrlFactory normalSiteUrlFactory, SiteUrlFactory mobileSiteUrlFactory, SiteUrlFactory tabletSiteUrlFactory, SitePreferenceHandler sitePreferenceHandler) {
        this.siteSwitcherHandler = new StandardSiteSwitcherHandler(normalSiteUrlFactory, mobileSiteUrlFactory, tabletSiteUrlFactory, sitePreferenceHandler, null);
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        return this.siteSwitcherHandler.handleSiteSwitch(request, response);
    }

    public static SiteSwitcherHandlerInterceptor mDot(String serverName) {
        return new SiteSwitcherHandlerInterceptor(StandardSiteSwitcherHandlerFactory.mDot(serverName));
    }

    public static SiteSwitcherHandlerInterceptor mDot(String serverName, Boolean tabletIsMobile) {
        return new SiteSwitcherHandlerInterceptor(StandardSiteSwitcherHandlerFactory.mDot(serverName, tabletIsMobile));
    }

    public static SiteSwitcherHandlerInterceptor dotMobi(String serverName) {
        return new SiteSwitcherHandlerInterceptor(StandardSiteSwitcherHandlerFactory.dotMobi(serverName));
    }

    public static SiteSwitcherHandlerInterceptor dotMobi(String serverName, Boolean tabletIsMobile) {
        return new SiteSwitcherHandlerInterceptor(StandardSiteSwitcherHandlerFactory.dotMobi(serverName, tabletIsMobile));
    }

    public static SiteSwitcherHandlerInterceptor standard(String normalServerName, String mobileServerName, String cookieDomain) {
        return new SiteSwitcherHandlerInterceptor(StandardSiteSwitcherHandlerFactory.standard(normalServerName, mobileServerName, cookieDomain));
    }

    public static SiteSwitcherHandlerInterceptor standard(String normalServerName, String mobileServerName, String cookieDomain, Boolean tabletIsMobile) {
        return new SiteSwitcherHandlerInterceptor(StandardSiteSwitcherHandlerFactory.standard(normalServerName, mobileServerName, cookieDomain, tabletIsMobile));
    }

    public static SiteSwitcherHandlerInterceptor standard(String normalServerName, String mobileServerName, String tabletServerName, String cookieDomain) {
        return new SiteSwitcherHandlerInterceptor(StandardSiteSwitcherHandlerFactory.standard(normalServerName, mobileServerName, tabletServerName, cookieDomain));
    }

    public static SiteSwitcherHandlerInterceptor urlPath(String mobilePath) {
        return new SiteSwitcherHandlerInterceptor(StandardSiteSwitcherHandlerFactory.urlPath(mobilePath));
    }

    public static SiteSwitcherHandlerInterceptor urlPath(String mobilePath, String rootPath) {
        return new SiteSwitcherHandlerInterceptor(StandardSiteSwitcherHandlerFactory.urlPath(mobilePath, rootPath));
    }

    public static SiteSwitcherHandlerInterceptor urlPath(String mobilePath, String tabletPath, String rootPath) {
        return new SiteSwitcherHandlerInterceptor(StandardSiteSwitcherHandlerFactory.urlPath(mobilePath, tabletPath, rootPath));
    }
}

