/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mobile.device;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.mobile.device.Device;
import org.springframework.mobile.device.DevicePlatform;
import org.springframework.mobile.device.DeviceResolver;
import org.springframework.mobile.device.DeviceType;
import org.springframework.mobile.device.LiteDevice;

public class LiteDeviceResolver
implements DeviceResolver {
    private final List<String> mobileUserAgentPrefixes = new ArrayList<String>();
    private final List<String> mobileUserAgentKeywords = new ArrayList<String>();
    private final List<String> tabletUserAgentKeywords = new ArrayList<String>();
    private final List<String> normalUserAgentKeywords = new ArrayList<String>();
    private static final String[] KNOWN_MOBILE_USER_AGENT_PREFIXES = new String[]{"w3c ", "w3c-", "acs-", "alav", "alca", "amoi", "avan", "benq", "bird", "blac", "blaz", "brew", "cell", "cldc", "cmd-", "dang", "doco", "eric", "hipt", "htc_", "inno", "ipaq", "ipod", "jigs", "kddi", "keji", "leno", "lg-c", "lg-d", "lg-g", "lge-", "lg/u", "maui", "maxo", "midp", "mits", "mmef", "mobi", "mot-", "moto", "mwbp", "nec-", "newt", "noki", "palm", "pana", "pant", "phil", "play", "port", "prox", "qwap", "sage", "sams", "sany", "sch-", "sec-", "send", "seri", "sgh-", "shar", "sie-", "siem", "smal", "smar", "sony", "sph-", "symb", "t-mo", "teli", "tim-", "tosh", "tsm-", "upg1", "upsi", "vk-v", "voda", "wap-", "wapa", "wapi", "wapp", "wapr", "webc", "winw", "winw", "xda ", "xda-"};
    private static final String[] KNOWN_MOBILE_USER_AGENT_KEYWORDS = new String[]{"blackberry", "webos", "ipod", "lge vx", "midp", "maemo", "mmp", "mobile", "netfront", "hiptop", "nintendo DS", "novarra", "openweb", "opera mobi", "opera mini", "palm", "psp", "phone", "smartphone", "symbian", "up.browser", "up.link", "wap", "windows ce"};
    private static final String[] KNOWN_TABLET_USER_AGENT_KEYWORDS = new String[]{"ipad", "playbook", "hp-tablet", "kindle"};

    public LiteDeviceResolver() {
        this.init();
    }

    public LiteDeviceResolver(List<String> normalUserAgentKeywords) {
        this.init();
        this.normalUserAgentKeywords.addAll(normalUserAgentKeywords);
    }

    @Override
    public Device resolveDevice(HttpServletRequest request) {
        String prefix;
        String userAgent = request.getHeader("User-Agent");
        if (userAgent != null) {
            userAgent = userAgent.toLowerCase();
            for (String string : this.normalUserAgentKeywords) {
                if (!userAgent.contains(string)) continue;
                return this.resolveFallback(request);
            }
        }
        if (userAgent != null) {
            if ((userAgent = userAgent.toLowerCase()).contains("android") && !userAgent.contains("mobile")) {
                return this.resolveWithPlatform(DeviceType.TABLET, DevicePlatform.ANDROID);
            }
            if (userAgent.contains("ipad")) {
                return this.resolveWithPlatform(DeviceType.TABLET, DevicePlatform.IOS);
            }
            if (userAgent.contains("silk") && !userAgent.contains("mobile")) {
                return this.resolveWithPlatform(DeviceType.TABLET, DevicePlatform.UNKNOWN);
            }
            for (String string : this.tabletUserAgentKeywords) {
                if (!userAgent.contains(string)) continue;
                return this.resolveWithPlatform(DeviceType.TABLET, DevicePlatform.UNKNOWN);
            }
        }
        if (request.getHeader("x-wap-profile") != null || request.getHeader("Profile") != null) {
            if (userAgent != null) {
                if (userAgent.contains("android")) {
                    return this.resolveWithPlatform(DeviceType.MOBILE, DevicePlatform.ANDROID);
                }
                if (userAgent.contains("iphone") || userAgent.contains("ipod") || userAgent.contains("ipad")) {
                    return this.resolveWithPlatform(DeviceType.MOBILE, DevicePlatform.IOS);
                }
            }
            return this.resolveWithPlatform(DeviceType.MOBILE, DevicePlatform.UNKNOWN);
        }
        if (userAgent != null && userAgent.length() >= 4 && this.mobileUserAgentPrefixes.contains(prefix = userAgent.substring(0, 4).toLowerCase())) {
            return this.resolveWithPlatform(DeviceType.MOBILE, DevicePlatform.UNKNOWN);
        }
        String accept = request.getHeader("Accept");
        if (accept != null && accept.contains("wap")) {
            return this.resolveWithPlatform(DeviceType.MOBILE, DevicePlatform.UNKNOWN);
        }
        if (userAgent != null) {
            if (userAgent.contains("android")) {
                return this.resolveWithPlatform(DeviceType.MOBILE, DevicePlatform.ANDROID);
            }
            if (userAgent.contains("iphone") || userAgent.contains("ipod") || userAgent.contains("ipad")) {
                return this.resolveWithPlatform(DeviceType.MOBILE, DevicePlatform.IOS);
            }
            for (String keyword : this.mobileUserAgentKeywords) {
                if (!userAgent.contains(keyword)) continue;
                return this.resolveWithPlatform(DeviceType.MOBILE, DevicePlatform.UNKNOWN);
            }
        }
        Enumeration enumeration = request.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            String header = (String)enumeration.nextElement();
            if (!header.contains("OperaMini")) continue;
            return this.resolveWithPlatform(DeviceType.MOBILE, DevicePlatform.UNKNOWN);
        }
        return this.resolveFallback(request);
    }

    protected Device resolveWithPlatform(DeviceType deviceType, DevicePlatform devicePlatform) {
        return LiteDevice.from(deviceType, devicePlatform);
    }

    protected List<String> getMobileUserAgentPrefixes() {
        return this.mobileUserAgentPrefixes;
    }

    protected List<String> getMobileUserAgentKeywords() {
        return this.mobileUserAgentKeywords;
    }

    protected List<String> getTabletUserAgentKeywords() {
        return this.tabletUserAgentKeywords;
    }

    protected List<String> getNormalUserAgentKeywords() {
        return this.normalUserAgentKeywords;
    }

    protected void init() {
        this.getMobileUserAgentPrefixes().addAll(Arrays.asList(KNOWN_MOBILE_USER_AGENT_PREFIXES));
        this.getMobileUserAgentKeywords().addAll(Arrays.asList(KNOWN_MOBILE_USER_AGENT_KEYWORDS));
        this.getTabletUserAgentKeywords().addAll(Arrays.asList(KNOWN_TABLET_USER_AGENT_KEYWORDS));
    }

    protected Device resolveFallback(HttpServletRequest request) {
        return LiteDevice.NORMAL_INSTANCE;
    }
}

