/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.Value;
import io.lettuce.core.internal.LettuceAssert;
import java.util.Optional;
import java.util.function.Function;

public class ScoredValue<V>
extends Value<V> {
    private static final ScoredValue<Object> EMPTY = new ScoredValue<Object>(0.0, null);
    private final double score;

    protected ScoredValue() {
        super(null);
        this.score = 0.0;
    }

    private ScoredValue(double score, V value) {
        super(value);
        this.score = score;
    }

    public static <T extends V, V> ScoredValue<V> from(double score, Optional<T> optional) {
        LettuceAssert.notNull(optional, "Optional must not be null");
        if (optional.isPresent()) {
            return new ScoredValue<T>(score, optional.get());
        }
        return ScoredValue.fromNullable(score, null);
    }

    public static <T extends V, V> ScoredValue<V> fromNullable(double score, T value) {
        if (value == null) {
            return new ScoredValue<Object>(score, null);
        }
        return new ScoredValue<T>(score, value);
    }

    public static <V> ScoredValue<V> empty() {
        return EMPTY;
    }

    public static <T extends V, V> ScoredValue<V> just(double score, T value) {
        LettuceAssert.notNull(value, "Value must not be null");
        return new ScoredValue<T>(score, value);
    }

    public double getScore() {
        return this.score;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScoredValue)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ScoredValue that = (ScoredValue)o;
        return Double.compare(that.score, this.score) == 0;
    }

    @Override
    public int hashCode() {
        long temp = Double.doubleToLongBits(this.score);
        int result = (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.hasValue() ? this.getValue().hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return this.hasValue() ? String.format("ScoredValue[%f, %s]", this.score, this.getValue()) : String.format("ScoredValue[%f].empty", this.score);
    }

    @Override
    public <R> ScoredValue<R> map(Function<? super V, ? extends R> mapper) {
        LettuceAssert.notNull(mapper, "Mapper function must not be null");
        if (this.hasValue()) {
            return new ScoredValue<R>(this.score, mapper.apply(this.getValue()));
        }
        return this;
    }

    public ScoredValue<V> mapScore(Function<? super Number, ? extends Number> mapper) {
        LettuceAssert.notNull(mapper, "Mapper function must not be null");
        if (this.hasValue()) {
            return new ScoredValue(mapper.apply((Number)this.score).doubleValue(), this.getValue());
        }
        return this;
    }
}

