/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.configuration.ConfigurationProvider;
import org.assertj.core.error.AssertionErrorCreator;
import org.assertj.core.error.AssertionErrorFactory;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.error.MessageFormatter;
import org.assertj.core.util.Strings;
import org.assertj.core.util.Throwables;
import org.assertj.core.util.VisibleForTesting;

public class Failures {
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private static final Failures INSTANCE = new Failures();
    private AssertionErrorCreator assertionErrorCreator = new AssertionErrorCreator();
    private boolean printThreadDump = false;
    private boolean removeAssertJRelatedElementsFromStackTrace = true;

    public static Failures instance() {
        return INSTANCE;
    }

    public void setRemoveAssertJRelatedElementsFromStackTrace(boolean removeAssertJRelatedElementsFromStackTrace) {
        ConfigurationProvider.loadRegisteredConfiguration();
        this.removeAssertJRelatedElementsFromStackTrace = removeAssertJRelatedElementsFromStackTrace;
    }

    public boolean isRemoveAssertJRelatedElementsFromStackTrace() {
        return this.removeAssertJRelatedElementsFromStackTrace;
    }

    @VisibleForTesting
    Failures() {
    }

    public AssertionError failure(AssertionInfo info, AssertionErrorFactory factory) {
        AssertionError error = this.failureIfErrorMessageIsOverridden(info);
        if (error != null) {
            return error;
        }
        this.printThreadDumpIfNeeded();
        return factory.newAssertionError(info.description(), info.representation());
    }

    public AssertionError failure(AssertionInfo info, ErrorMessageFactory messageFactory) {
        AssertionError error = this.failureIfErrorMessageIsOverridden(info);
        if (error != null) {
            return error;
        }
        AssertionError assertionError = new AssertionError((Object)messageFactory.create(info.description(), info.representation()));
        this.removeAssertJRelatedElementsFromStackTraceIfNeeded(assertionError);
        this.printThreadDumpIfNeeded();
        return assertionError;
    }

    public AssertionError failure(AssertionInfo info, ErrorMessageFactory messageFactory, Object actual, Object expected) {
        String assertionErrorMessage = this.assertionErrorMessage(info, messageFactory);
        AssertionError assertionError = this.assertionErrorCreator.assertionError(assertionErrorMessage, actual, expected);
        this.removeAssertJRelatedElementsFromStackTraceIfNeeded(assertionError);
        this.printThreadDumpIfNeeded();
        return assertionError;
    }

    protected String assertionErrorMessage(AssertionInfo info, ErrorMessageFactory messageFactory) {
        String overridingErrorMessage = info.overridingErrorMessage();
        String message = Strings.isNullOrEmpty(overridingErrorMessage) ? messageFactory.create(info.description(), info.representation()) : MessageFormatter.instance().format(info.description(), info.representation(), overridingErrorMessage, new Object[0]);
        return message;
    }

    public AssertionError failureIfErrorMessageIsOverridden(AssertionInfo info) {
        String overridingErrorMessage = info.overridingErrorMessage();
        return Strings.isNullOrEmpty(overridingErrorMessage) ? null : this.failure(MessageFormatter.instance().format(info.description(), info.representation(), overridingErrorMessage, new Object[0]));
    }

    public AssertionError failure(String message) {
        AssertionError assertionError = new AssertionError((Object)message);
        this.removeAssertJRelatedElementsFromStackTraceIfNeeded(assertionError);
        this.printThreadDumpIfNeeded();
        return assertionError;
    }

    public AssertionError expectedThrowableNotThrown(Class<? extends Throwable> throwableClass) {
        return this.failure(String.format("%s should have been thrown", throwableClass.getSimpleName()));
    }

    public void printThreadDumpIfNeeded() {
        if (this.printThreadDump) {
            System.err.println(Failures.threadDumpDescription());
        }
    }

    public void removeAssertJRelatedElementsFromStackTraceIfNeeded(AssertionError assertionError) {
        if (this.removeAssertJRelatedElementsFromStackTrace) {
            Throwables.removeAssertJRelatedElementsFromStackTrace((Throwable)((Object)assertionError));
        }
    }

    public void enablePrintThreadDump() {
        this.printThreadDump = true;
    }

    public static String threadDumpDescription() {
        ThreadInfo[] threadInfos;
        StringBuilder threadDumpDescription = new StringBuilder();
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        for (ThreadInfo threadInfo : threadInfos = threadMXBean.dumpAllThreads(true, true)) {
            threadDumpDescription.append(String.format("\"%s\"%n\tjava.lang.Thread.State: %s", new Object[]{threadInfo.getThreadName(), threadInfo.getThreadState()}));
            for (StackTraceElement stackTraceElement : threadInfo.getStackTrace()) {
                threadDumpDescription.append(LINE_SEPARATOR).append("\t\tat ").append(stackTraceElement);
            }
            threadDumpDescription.append(LINE_SEPARATOR).append(LINE_SEPARATOR);
        }
        return threadDumpDescription.toString();
    }
}

