/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.hazelcast;

import com.hazelcast.core.HazelcastInstance;
import java.util.Map;
import org.springframework.boot.actuate.autoconfigure.health.CompositeHealthContributorConfiguration;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.hazelcast.HazelcastHealthIndicator;
import org.springframework.boot.actuate.health.HealthContributor;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.hazelcast.HazelcastAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={HazelcastInstance.class})
@ConditionalOnBean(value={HazelcastInstance.class})
@ConditionalOnEnabledHealthIndicator(value="hazelcast")
@AutoConfigureAfter(value={HazelcastAutoConfiguration.class})
public class HazelcastHealthContributorAutoConfiguration
extends CompositeHealthContributorConfiguration<HazelcastHealthIndicator, HazelcastInstance> {
    @Bean
    @ConditionalOnMissingBean(name={"hazelcastHealthIndicator", "hazelcastHealthContributor"})
    public HealthContributor hazelcastHealthContributor(Map<String, HazelcastInstance> hazelcastInstances) {
        return (HealthContributor)this.createContributor(hazelcastInstances);
    }
}

