/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.error.GroupTypeDescription;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.StandardComparisonStrategy;
import org.assertj.core.util.IterableUtil;

public class ShouldContainOnly
extends BasicErrorMessageFactory {
    public static ErrorMessageFactory shouldContainOnly(Object actual, Object expected, Iterable<?> notFound, Iterable<?> notExpected, ComparisonStrategy comparisonStrategy) {
        GroupTypeDescription groupTypeDescription = GroupTypeDescription.getGroupTypeDescription(actual);
        if (IterableUtil.isNullOrEmpty(notExpected)) {
            return new ShouldContainOnly(actual, expected, notFound, ErrorType.NOT_FOUND_ONLY, comparisonStrategy, groupTypeDescription);
        }
        if (IterableUtil.isNullOrEmpty(notFound)) {
            return new ShouldContainOnly(actual, expected, notExpected, ErrorType.NOT_EXPECTED_ONLY, comparisonStrategy, groupTypeDescription);
        }
        return new ShouldContainOnly(actual, expected, notFound, notExpected, comparisonStrategy, groupTypeDescription);
    }

    public static ErrorMessageFactory shouldContainOnly(Object actual, Object expected, Iterable<?> notFound, Iterable<?> notExpected) {
        return ShouldContainOnly.shouldContainOnly(actual, expected, notFound, notExpected, StandardComparisonStrategy.instance());
    }

    private ShouldContainOnly(Object actual, Object expected, Iterable<?> notFound, Iterable<?> notExpected, ComparisonStrategy comparisonStrategy, GroupTypeDescription groupTypeDescription) {
        super("%nExpecting " + groupTypeDescription.getGroupTypeName() + ":%n  <%s>%nto contain only:%n  <%s>%n" + groupTypeDescription.getElementTypeName() + " not found:%n  <%s>%nand " + groupTypeDescription.getElementTypeName() + " not expected:%n  <%s>%n%s", actual, expected, notFound, notExpected, comparisonStrategy);
    }

    private ShouldContainOnly(Object actual, Object expected, Iterable<?> notFoundOrNotExpected, ErrorType errorType, ComparisonStrategy comparisonStrategy, GroupTypeDescription groupTypeDescription) {
        super("%nExpecting " + groupTypeDescription.getGroupTypeName() + ":%n  <%s>%nto contain only:%n  <%s>%n" + (errorType == ErrorType.NOT_FOUND_ONLY ? "but could not find the following " + groupTypeDescription.getElementTypeName() + ":%n" : "but the following " + groupTypeDescription.getElementTypeName() + " were unexpected:%n") + "  <%s>%n%s", actual, expected, notFoundOrNotExpected, comparisonStrategy);
    }

    public static enum ErrorType {
        NOT_FOUND_ONLY,
        NOT_EXPECTED_ONLY;

    }
}

