/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.plugins.pagination.dialects;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.DB2Dialect;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.IDialect;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.MySqlDialect;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.Oracle12cDialect;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.OracleDialect;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.PostgreDialect;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.SQLServer2005Dialect;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.SQLServerDialect;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.SybaseDialect;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;

public class DialectRegistry {
    private final Map<DbType, IDialect> dialect_enum_map = new EnumMap<DbType, IDialect>(DbType.class);

    public DialectRegistry() {
        this.dialect_enum_map.put(DbType.MYSQL, new MySqlDialect());
        this.dialect_enum_map.put(DbType.MARIADB, new MySqlDialect());
        this.dialect_enum_map.put(DbType.GBASE, new MySqlDialect());
        this.dialect_enum_map.put(DbType.OSCAR, new MySqlDialect());
        this.dialect_enum_map.put(DbType.XU_GU, new MySqlDialect());
        this.dialect_enum_map.put(DbType.CLICK_HOUSE, new MySqlDialect());
        this.dialect_enum_map.put(DbType.OCEAN_BASE, new MySqlDialect());
        this.dialect_enum_map.put(DbType.POSTGRE_SQL, new PostgreDialect());
        this.dialect_enum_map.put(DbType.H2, new PostgreDialect());
        this.dialect_enum_map.put(DbType.SQLITE, new PostgreDialect());
        this.dialect_enum_map.put(DbType.HSQL, new PostgreDialect());
        this.dialect_enum_map.put(DbType.KINGBASE_ES, new PostgreDialect());
        this.dialect_enum_map.put(DbType.PHOENIX, new PostgreDialect());
        this.dialect_enum_map.put(DbType.ORACLE, new OracleDialect());
        this.dialect_enum_map.put(DbType.DM, new OracleDialect());
        this.dialect_enum_map.put(DbType.GAUSS, new OracleDialect());
        this.dialect_enum_map.put(DbType.ORACLE_12C, new Oracle12cDialect());
        this.dialect_enum_map.put(DbType.DB2, new DB2Dialect());
        this.dialect_enum_map.put(DbType.SQL_SERVER2005, new SQLServer2005Dialect());
        this.dialect_enum_map.put(DbType.SQL_SERVER, new SQLServerDialect());
        this.dialect_enum_map.put(DbType.SYBASE, new SybaseDialect());
    }

    public IDialect getDialect(DbType dbType) {
        return this.dialect_enum_map.get(dbType);
    }

    public Collection<IDialect> getDialects() {
        return Collections.unmodifiableCollection(this.dialect_enum_map.values());
    }
}

