/*
 * Decompiled with CFR 0.152.
 */
package org.attoparser.select;

import org.attoparser.AbstractChainedMarkupHandler;
import org.attoparser.IMarkupHandler;
import org.attoparser.ParseException;
import org.attoparser.select.ParseSelection;

public final class AttributeSelectionMarkingMarkupHandler
extends AbstractChainedMarkupHandler {
    private static final char[] INNER_WHITESPACE_BUFFER = " ".toCharArray();
    private final char[] selectorAttributeName;
    private final int selectorAttributeNameLen;
    private ParseSelection selection;
    private boolean lastWasInnerWhiteSpace = false;
    private char[] selectorAttributeBuffer;

    public AttributeSelectionMarkingMarkupHandler(String selectorAttributeName, IMarkupHandler handler) {
        super(handler);
        if (selectorAttributeName == null || selectorAttributeName.trim().length() == 0) {
            throw new IllegalArgumentException("Selector attribute name cannot be null or empty");
        }
        this.selectorAttributeName = selectorAttributeName.toCharArray();
        this.selectorAttributeNameLen = this.selectorAttributeName.length;
        this.selectorAttributeBuffer = new char[this.selectorAttributeNameLen + 20];
        System.arraycopy(this.selectorAttributeName, 0, this.selectorAttributeBuffer, 0, this.selectorAttributeNameLen);
        this.selectorAttributeBuffer[this.selectorAttributeNameLen] = 61;
        this.selectorAttributeBuffer[this.selectorAttributeNameLen + 1] = 34;
    }

    @Override
    public void setParseSelection(ParseSelection selection) {
        this.selection = selection;
        super.setParseSelection(selection);
    }

    @Override
    public void handleAttribute(char[] buffer, int nameOffset, int nameLen, int nameLine, int nameCol, int operatorOffset, int operatorLen, int operatorLine, int operatorCol, int valueContentOffset, int valueContentLen, int valueOuterOffset, int valueOuterLen, int valueLine, int valueCol) throws ParseException {
        this.lastWasInnerWhiteSpace = false;
        this.getNext().handleAttribute(buffer, nameOffset, nameLen, nameLine, nameCol, operatorOffset, operatorLen, operatorLine, operatorCol, valueContentOffset, valueContentLen, valueOuterOffset, valueOuterLen, valueLine, valueCol);
    }

    @Override
    public void handleStandaloneElementEnd(char[] buffer, int nameOffset, int nameLen, boolean minimized, int line, int col) throws ParseException {
        if (this.selection.isMatchingAny()) {
            if (!this.lastWasInnerWhiteSpace) {
                this.getNext().handleInnerWhiteSpace(INNER_WHITESPACE_BUFFER, 0, INNER_WHITESPACE_BUFFER.length, line, col);
                this.lastWasInnerWhiteSpace = true;
            }
            String selectorValues = this.selection.toString();
            int selectorValuesLen = selectorValues.length();
            this.checkSelectorAttributeLen(selectorValuesLen);
            selectorValues.getChars(0, selectorValuesLen, this.selectorAttributeBuffer, this.selectorAttributeNameLen + 2);
            this.selectorAttributeBuffer[this.selectorAttributeNameLen + 2 + selectorValuesLen] = 34;
            this.getNext().handleAttribute(this.selectorAttributeBuffer, 0, this.selectorAttributeNameLen, line, col, this.selectorAttributeNameLen, 1, line, col, this.selectorAttributeNameLen + 2, selectorValuesLen, this.selectorAttributeNameLen + 1, selectorValuesLen + 2, line, col);
        }
        this.lastWasInnerWhiteSpace = false;
        this.getNext().handleStandaloneElementEnd(buffer, nameOffset, nameLen, minimized, line, col);
    }

    @Override
    public void handleOpenElementEnd(char[] buffer, int nameOffset, int nameLen, int line, int col) throws ParseException {
        if (this.selection.isMatchingAny()) {
            if (!this.lastWasInnerWhiteSpace) {
                this.getNext().handleInnerWhiteSpace(INNER_WHITESPACE_BUFFER, 0, INNER_WHITESPACE_BUFFER.length, line, col);
                this.lastWasInnerWhiteSpace = true;
            }
            String selectorValues = this.selection.toString();
            int selectorValuesLen = selectorValues.length();
            this.checkSelectorAttributeLen(selectorValuesLen);
            selectorValues.getChars(0, selectorValuesLen, this.selectorAttributeBuffer, this.selectorAttributeNameLen + 2);
            this.selectorAttributeBuffer[this.selectorAttributeNameLen + 2 + selectorValuesLen] = 34;
            this.getNext().handleAttribute(this.selectorAttributeBuffer, 0, this.selectorAttributeNameLen, line, col, this.selectorAttributeNameLen, 1, line, col, this.selectorAttributeNameLen + 2, selectorValuesLen, this.selectorAttributeNameLen + 1, selectorValuesLen + 2, line, col);
        }
        this.lastWasInnerWhiteSpace = false;
        this.getNext().handleOpenElementEnd(buffer, nameOffset, nameLen, line, col);
    }

    @Override
    public void handleInnerWhiteSpace(char[] buffer, int offset, int len, int line, int col) throws ParseException {
        this.lastWasInnerWhiteSpace = true;
        this.getNext().handleInnerWhiteSpace(buffer, offset, len, line, col);
    }

    private void checkSelectorAttributeLen(int valueLen) {
        int totalLenRequired = this.selectorAttributeNameLen + 3 + valueLen;
        if (this.selectorAttributeBuffer.length < totalLenRequired) {
            char[] newSelectorAttributeBuffer = new char[totalLenRequired];
            System.arraycopy(this.selectorAttributeBuffer, 0, newSelectorAttributeBuffer, 0, this.selectorAttributeBuffer.length);
            this.selectorAttributeBuffer = newSelectorAttributeBuffer;
        }
    }
}

