/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.thymeleaf.exceptions.TemplateProcessingException;

public final class RestrictedRequestAccessUtils {
    public static Object wrapRequestObject(Object obj) {
        if (obj == null || !(obj instanceof HttpServletRequest)) {
            return obj;
        }
        return new RestrictedRequestWrapper((HttpServletRequest)obj);
    }

    private RestrictedRequestAccessUtils() {
    }

    private static class RestrictedRequestWrapper
    extends HttpServletRequestWrapper {
        public RestrictedRequestWrapper(HttpServletRequest request) {
            super(request);
        }

        public String getParameter(String name) {
            throw RestrictedRequestWrapper.createRestrictedParameterAccessException();
        }

        public Map getParameterMap() {
            throw RestrictedRequestWrapper.createRestrictedParameterAccessException();
        }

        public String[] getParameterValues(String name) {
            throw RestrictedRequestWrapper.createRestrictedParameterAccessException();
        }

        public String getQueryString() {
            throw RestrictedRequestWrapper.createRestrictedParameterAccessException();
        }

        private static TemplateProcessingException createRestrictedParameterAccessException() {
            return new TemplateProcessingException("Access to request parameters is forbidden in this context. Note some restrictions apply to variable access. For example, direct access to request parameters is forbidden in preprocessing and unescaped expressions, in TEXT template mode, in fragment insertion specifications and in some specific attribute processors.");
        }
    }
}

